/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.layout.absolute;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.handles.MoveHandle;
import org.eclipse.wb.gef.graphical.handles.ResizeHandle;
import org.eclipse.wb.gef.graphical.policies.SelectionEditPolicy;
import org.eclipse.wb.gef.graphical.tools.ResizeTracker;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.AbsoluteBasedLayoutEditPolicy;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementsSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsoluteBasedSelectionEditPolicy<C extends IAbstractComponentInfo>
extends SelectionEditPolicy {
    public static final String REQ_RESIZE = "_absolute_resize";

    @Override
    protected List<Handle> createSelectionHandles() {
        List handles = Lists.newArrayList();
        MoveHandle moveHandle = new MoveHandle(this.getHost());
        handles.add(moveHandle);
        handles.add(this.createResizeHandle(1));
        handles.add(this.createResizeHandle(4));
        handles.add(this.createResizeHandle(8));
        handles.add(this.createResizeHandle(16));
        handles.add(this.createResizeHandle(20));
        handles.add(this.createResizeHandle(12));
        handles.add(this.createResizeHandle(9));
        handles.add(this.createResizeHandle(17));
        return handles;
    }

    private Handle createResizeHandle(int direction) {
        ResizeHandle handle = new ResizeHandle(this.getHost(), direction);
        handle.setDragTrackerTool(new ResizeTracker(direction, (Object)REQ_RESIZE){

            protected Command getCommand() {
                return AbsoluteBasedSelectionEditPolicy.this.getLayoutEditPolicy().getResizeCommandImpl(this.getRequest());
            }

            protected void showSourceFeedback() {
                AbsoluteBasedSelectionEditPolicy.this.getLayoutEditPolicy().showResizeFeedback(this.getRequest());
                this.setShowingFeedback(true);
            }

            protected void eraseSourceFeedback() {
                if (this.isShowingFeedback()) {
                    this.setShowingFeedback(false);
                    AbsoluteBasedSelectionEditPolicy.this.getLayoutEditPolicy().eraseResizeFeedback(this.getRequest());
                }
            }
        });
        return handle;
    }

    @Override
    public boolean understandsRequest(Request request) {
        return super.understandsRequest(request) || request.getType() == REQ_RESIZE;
    }

    @Override
    public void performRequest(Request request) {
        this.getLayoutEditPolicy().performRequest(request);
    }

    protected final AbsoluteBasedLayoutEditPolicy<C> getLayoutEditPolicy() {
        return (AbsoluteBasedLayoutEditPolicy)this.getHost().getParent().getEditPolicy("LayoutEditPolicy");
    }

    protected final PlacementsSupport getPlacementsSupport() {
        return this.getLayoutEditPolicy().getPlacementsSupport();
    }
}

