/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.table;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.table.IPropertyTooltipSite;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.utils.IAdaptable;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

class PropertyTableTooltipHelper
implements IPropertyTooltipSite {
    private final PropertyTable m_table;
    private Shell m_tooltip;
    private Property m_property;
    private boolean m_onTitle;
    private boolean m_onValue;
    private int m_beginX;
    private int m_endX;
    private int m_y;
    private int m_rowHeight;

    public PropertyTableTooltipHelper(PropertyTable table) {
        this.m_table = table;
        this.m_table.addListener(32, new Listener(){

            public void handleEvent(Event event) {
                if (event.stateMask == 0) {
                    PropertyTableTooltipHelper.this.showTooltip();
                }
            }
        });
        this.m_table.addListener(7, new Listener(){

            public void handleEvent(Event event) {
                Control control = Display.getCurrent().getCursorControl();
                while (control != null) {
                    if (control == PropertyTableTooltipHelper.this.m_tooltip) {
                        return;
                    }
                    control = control.getParent();
                }
                PropertyTableTooltipHelper.this.hideTooltip();
            }
        });
    }

    public void update(Property property, boolean onTitle, boolean onValue, int beginX, int endX, int y, int rowHeight) {
        this.m_property = property;
        this.m_onTitle = onTitle;
        this.m_onValue = onValue;
        this.m_beginX = beginX;
        this.m_endX = endX;
        this.m_y = y;
        this.m_rowHeight = rowHeight;
    }

    public PropertyTable getTable() {
        return this.m_table;
    }

    public void hideTooltip() {
        if (this.m_tooltip != null && !this.m_tooltip.isDisposed()) {
            this.m_tooltip.dispose();
        }
        this.m_tooltip = null;
    }

    private void showTooltip() {
        this.hideTooltip();
        if (this.m_property == null) {
            return;
        }
        if (this.m_onTitle) {
            this.showTooltip(this.m_property, this.m_beginX, this.m_endX);
        }
        if (this.m_onValue) {
            this.showTooltip(this.m_property.getEditor(), this.m_beginX, this.m_endX);
        }
    }

    private void showTooltip(IAdaptable adaptable, int startX, int endX) {
        PropertyTooltipProvider provider = null;
        provider = adaptable.getAdapter(PropertyTooltipProvider.class);
        if (provider == null) {
            return;
        }
        this.m_tooltip = new Shell(this.m_table.getShell(), 540676);
        this.configureColors((Control)this.m_tooltip);
        GridLayoutFactory.create((Composite)this.m_tooltip).noMargins();
        Control control = provider.createTooltipControl(this.m_property, (Composite)this.m_tooltip, endX - startX, this);
        if (control == null) {
            this.hideTooltip();
            return;
        }
        Point tooltipLocation = provider.getTooltipPosition() == 0 ? this.m_table.toDisplay(new Point(startX, this.m_y)) : this.m_table.toDisplay(new Point(startX, this.m_y + this.m_rowHeight));
        this.m_tooltip.setLocation(tooltipLocation.x, tooltipLocation.y);
        if (!EnvironmentUtils.IS_WINDOWS) {
            this.m_tooltip.setSize(1000, 1000);
        }
        this.m_tooltip.setSize(this.m_tooltip.computeSize(-1, -1));
        provider.show(this.m_tooltip);
    }

    private void configureColors(Control control) {
        Display display = Display.getCurrent();
        control.setForeground(display.getSystemColor(28));
        control.setBackground(display.getSystemColor(29));
    }
}

