/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.PropertyManager;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ResizableDialog;

public class ImportantPropertiesDialog
extends ResizableDialog {
    private final JavaInfo m_javaInfo;
    private PropertyTable m_propertyTable;
    private final ObjectEventListener m_refreshListener = new ObjectEventListener(){

        public void refreshed() throws Exception {
            ImportantPropertiesDialog.this.m_propertyTable.redraw();
        }
    };

    public static void scheduleImportantProperties(final JavaInfo javaInfo) {
        IPreferenceStore preferences = javaInfo.getDescription().getToolkit().getPreferences();
        if (preferences.getBoolean("general.importantPropertiesAfterAdd") && javaInfo.getArbitraryValue("manuallyCreatedComponent") == Boolean.TRUE) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ImportantPropertiesDialog dialog = new ImportantPropertiesDialog(DesignerPlugin.getShell(), javaInfo, null);
                    dialog.open();
                }
            });
        }
    }

    private ImportantPropertiesDialog(Shell parentShell, JavaInfo javaInfo) {
        super(parentShell, (AbstractUIPlugin)DesignerPlugin.getDefault());
        this.m_javaInfo = javaInfo;
        this.setShellStyle(67680);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        area.setLayout((Layout)new GridLayout());
        this.m_propertyTable = new PropertyTable(area, 2048);
        GridDataFactory.create((Control)this.m_propertyTable).grab().fill().hintC(55, 20);
        this.m_javaInfo.addBroadcastListener(this.m_refreshListener);
        try {
            this.showImportantProperties();
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
        }
        return area;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ModelMessages.ImportantPropertiesDialog_title);
    }

    public boolean close() {
        this.m_javaInfo.removeBroadcastListener(this.m_refreshListener);
        return super.close();
    }

    protected void okPressed() {
        this.m_propertyTable.deactivateEditor(true);
        super.okPressed();
    }

    private void showImportantProperties() throws Exception {
        List importantProperties = Lists.newArrayList();
        Property[] propertyArray = this.m_javaInfo.getProperties();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property property = propertyArray[n2];
            PropertyCategory category = PropertyManager.getCategory((Property)property);
            if (category.isPreferred() || category.isSystem()) {
                importantProperties.add(property);
            }
            ++n2;
        }
        this.m_propertyTable.setInput(importantProperties.toArray(new Property[importantProperties.size()]));
    }

    /* synthetic */ ImportantPropertiesDialog(Shell shell, JavaInfo javaInfo, ImportantPropertiesDialog importantPropertiesDialog) {
        this(shell, javaInfo);
    }
}

