/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.templates;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.mvel2.CompileException;
import org.mvel2.ParserContext;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.res.CodeNode;
import org.mvel2.templates.res.CommentNode;
import org.mvel2.templates.res.DeclareNode;
import org.mvel2.templates.res.EndNode;
import org.mvel2.templates.res.ExpressionNode;
import org.mvel2.templates.res.ForEachNode;
import org.mvel2.templates.res.IfNode;
import org.mvel2.templates.res.IncludeNode;
import org.mvel2.templates.res.NamedIncludeNode;
import org.mvel2.templates.res.Node;
import org.mvel2.templates.res.TerminalExpressionNode;
import org.mvel2.templates.res.TerminalNode;
import org.mvel2.templates.res.TextNode;
import org.mvel2.templates.util.TemplateTools;
import org.mvel2.util.ExecutionStack;
import org.mvel2.util.ParseTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateCompiler {
    private char[] template;
    private int length;
    private int start;
    private int cursor;
    private int lastTextRangeEnding;
    private int line;
    private int colStart;
    private Map<String, Class<? extends Node>> customNodes;
    private static final Map<String, Integer> OPCODES = new HashMap<String, Integer>();

    static {
        OPCODES.put("if", 1);
        OPCODES.put("else", 2);
        OPCODES.put("elseif", 2);
        OPCODES.put("end", 10);
        OPCODES.put("foreach", 3);
        OPCODES.put("includeNamed", 51);
        OPCODES.put("include", 50);
        OPCODES.put("comment", 52);
        OPCODES.put("code", 53);
        OPCODES.put("declare", 54);
        OPCODES.put("stop", 70);
    }

    public CompiledTemplate compile() {
        return new CompiledTemplate(this.template, this.compileFrom(null, new ExecutionStack()));
    }

    /*
     * Unable to fully structure code
     */
    public Node compileFrom(Node root, ExecutionStack stack) {
        this.line = 1;
        n = root;
        if (root == null) {
            n = root = new TextNode(0, 0);
        }
        try {
            while (this.cursor < this.length) {
                switch (this.template[this.cursor]) {
                    case '\n': {
                        ++this.line;
                        this.colStart = this.cursor + 1;
                        ** GOTO lbl104
                    }
                    case '$': 
                    case '@': {
                        if (this.isNext(this.template[this.cursor])) {
                            this.start = ++this.cursor;
                            n = this.markTextNode(n);
                            n.setEnd(n.getEnd() + 1);
                            this.lastTextRangeEnding = ++this.cursor;
                            break;
                        }
                        x = this.captureOrbToken();
                        if (x != -1) {
                            this.start = x;
                            name = new String(this.capture());
                            opcode = TemplateCompiler.OPCODES.get(name);
                            switch (opcode == null ? 0 : opcode) {
                                case 1: {
                                    n = this.markTextNode((Node)n).next = new IfNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                    stack.push(this.markTextNode((Node)n).next);
                                    n.setTerminus(new TerminalNode());
                                    break;
                                }
                                case 2: {
                                    if (stack.isEmpty() || !(stack.peek() instanceof IfNode)) break;
                                    last = (IfNode)stack.pop();
                                    this.markTextNode((Node)n).next = last.getTerminus();
                                    last.demarcate(last.getTerminus(), this.template);
                                    last.next = n = new IfNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                    n.setTerminus(last.getTerminus());
                                    stack.push(n);
                                    break;
                                }
                                case 3: {
                                    n = this.markTextNode((Node)n).next = new ForEachNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                    stack.push(this.markTextNode((Node)n).next);
                                    n.setTerminus(new TerminalNode());
                                    break;
                                }
                                case 50: {
                                    this.start = this.cursor + 1;
                                    n = this.markTextNode((Node)n).next = new IncludeNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                    break;
                                }
                                case 51: {
                                    this.start = this.cursor + 1;
                                    n = this.markTextNode((Node)n).next = new NamedIncludeNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                    break;
                                }
                                case 53: {
                                    this.start = this.cursor + 1;
                                    n = this.markTextNode((Node)n).next = new CodeNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                    break;
                                }
                                case 52: {
                                    this.start = this.cursor + 1;
                                    n = this.markTextNode((Node)n).next = new CommentNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                    break;
                                }
                                case 54: {
                                    this.start = this.cursor + 1;
                                    n = this.markTextNode((Node)n).next = new DeclareNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                    stack.push(this.markTextNode((Node)n).next);
                                    n.setTerminus(new TerminalNode());
                                    break;
                                }
                                case 10: {
                                    n = this.markTextNode(n);
                                    end = (Node)stack.pop();
                                    terminal = end.getTerminus();
                                    terminal.setCStart(this.captureOrbInternal());
                                    this.lastTextRangeEnding = this.start;
                                    terminal.setEnd(this.lastTextRangeEnding - 1);
                                    terminal.calculateContents(this.template);
                                    if (end.demarcate(terminal, this.template)) {
                                        n = n.next = terminal;
                                        break;
                                    }
                                    n = terminal;
                                    break;
                                }
                                default: {
                                    if (name.length() == 0) {
                                        this.start = this.cursor + 1;
                                        n = this.markTextNode((Node)n).next = new ExpressionNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                        break;
                                    }
                                    if (this.customNodes != null && this.customNodes.containsKey(name)) {
                                        customNode = this.customNodes.get(name);
                                        try {
                                            n = this.markTextNode((Node)n).next = customNode.newInstance();
                                            this.markTextNode((Node)n).next.setBegin(this.start);
                                            n.setName(name);
                                            n.setCStart(this.captureOrbInternal());
                                            this.start = this.cursor + 1;
                                            n.setCEnd(this.start);
                                            n.setEnd(n.getCEnd());
                                            n.setContents(ParseTools.subset(this.template, n.getCStart(), n.getCEnd() - n.getCStart() - 1));
                                            if (!n.isOpenNode()) break;
                                            stack.push(n);
                                            break;
                                        }
                                        catch (InstantiationException e) {
                                            throw new RuntimeException("unable to instantiate custom node class: " + customNode.getName());
                                        }
                                        catch (IllegalAccessException e) {
                                            throw new RuntimeException("unable to instantiate custom node class: " + customNode.getName());
                                        }
                                    }
                                    throw new RuntimeException("unknown token type: " + name);
                                }
                            }
                        }
                    }
lbl104:
                    // 18 sources

                    default: {
                        ++this.cursor;
                    }
                }
            }
        }
        catch (RuntimeException e) {
            ce = new CompileException(e.getMessage());
            ce.setExpr(this.template);
            if (e instanceof CompileException && (ce2 = (CompileException)e).getCursor() != -1) {
                ce.setCursor(ce2.getCursor());
                if (ce2.getColumn() == -1) {
                    ce.setColumn(ce.getCursor() - this.colStart);
                } else {
                    ce.setColumn(ce2.getColumn());
                }
            }
            ce.setLineNumber(this.line);
            throw ce;
        }
        if (!stack.isEmpty()) {
            ce = new CompileException("unclosed @" + ((Node)stack.peek()).getName() + "{} block. expected @end{}", this.template, this.cursor);
            ce.setColumn(this.cursor - this.colStart);
            ce.setLineNumber(this.line);
            throw ce;
        }
        if (this.start < this.template.length) {
            n = n.next = new TextNode(this.start, this.template.length);
        }
        n.next = new EndNode();
        n = root;
        while (n.getLength() == 0 && (n = n.getNext()) != null) {
        }
        if (n != null && n.getLength() == this.template.length - 1) {
            if (n instanceof ExpressionNode) {
                return new TerminalExpressionNode(n);
            }
            return n;
        }
        return root;
    }

    public boolean isNext(char c) {
        return this.cursor != this.length && this.template[this.cursor + 1] == c;
    }

    public int captureOrbToken() {
        int newStart = ++this.cursor;
        while (this.cursor != this.length && ParseTools.isIdentifierPart(this.template[this.cursor])) {
            ++this.cursor;
        }
        if (this.cursor != this.length && this.template[this.cursor] == '{') {
            return newStart;
        }
        return -1;
    }

    public int captureOrbInternal() {
        try {
            ParserContext pCtx = new ParserContext();
            this.start = this.cursor;
            this.cursor = ParseTools.balancedCaptureWithLineAccounting(this.template, this.start, '{', pCtx);
            this.line += pCtx.getLineCount();
            int ret = this.start + 1;
            this.start = this.cursor + 1;
            return ret;
        }
        catch (CompileException e) {
            e.setLineNumber(this.line);
            e.setColumn(this.cursor - this.colStart + 1);
            throw e;
        }
    }

    public char[] capture() {
        char[] newChar = new char[this.cursor - this.start];
        int i = 0;
        while (i < newChar.length) {
            newChar[i] = this.template[i + this.start];
            ++i;
        }
        return newChar;
    }

    public Node markTextNode(Node n) {
        int s;
        int n2 = s = n.getEnd() > this.lastTextRangeEnding ? n.getEnd() : this.lastTextRangeEnding;
        if (s < this.start) {
            this.lastTextRangeEnding = this.start - 1;
            n.next = new TextNode(s, this.lastTextRangeEnding);
            return n.next;
        }
        return n;
    }

    public static CompiledTemplate compileTemplate(String template) {
        return new TemplateCompiler(template).compile();
    }

    public static CompiledTemplate compileTemplate(char[] template) {
        return new TemplateCompiler(template).compile();
    }

    public static CompiledTemplate compileTemplate(CharSequence template) {
        return new TemplateCompiler(template).compile();
    }

    public static CompiledTemplate compileTemplate(String template, Map<String, Class<? extends Node>> customNodes) {
        return new TemplateCompiler(template, customNodes).compile();
    }

    public static CompiledTemplate compileTemplate(char[] template, Map<String, Class<? extends Node>> customNodes) {
        return new TemplateCompiler(template, customNodes).compile();
    }

    public static CompiledTemplate compileTemplate(CharSequence template, Map<String, Class<? extends Node>> customNodes) {
        return new TemplateCompiler(template, customNodes).compile();
    }

    public static CompiledTemplate compileTemplate(InputStream stream, Map<String, Class<? extends Node>> customNodes) {
        return new TemplateCompiler(TemplateTools.readStream(stream), customNodes).compile();
    }

    public static CompiledTemplate compileTemplate(File file, Map<String, Class<? extends Node>> customNodes) {
        return new TemplateCompiler(TemplateTools.readInFile(file), customNodes).compile();
    }

    public TemplateCompiler(String template) {
        this.template = template.toCharArray();
        this.length = this.template.length;
    }

    public TemplateCompiler(char[] template) {
        this.template = template;
        this.length = template.length;
    }

    public TemplateCompiler(CharSequence sequence) {
        this.template = sequence.toString().toCharArray();
        this.length = this.template.length;
    }

    public TemplateCompiler(String template, Map<String, Class<? extends Node>> customNodes) {
        this.template = template.toCharArray();
        this.length = this.template.length;
        this.customNodes = customNodes;
    }

    public TemplateCompiler(char[] template, Map<String, Class<? extends Node>> customNodes) {
        this.template = template;
        this.length = template.length;
        this.customNodes = customNodes;
    }

    public TemplateCompiler(CharSequence sequence, Map<String, Class<? extends Node>> customNodes) {
        this.template = sequence.toString().toCharArray();
        this.length = this.template.length;
        this.customNodes = customNodes;
    }
}

