/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.model.ui;

import java.text.MessageFormat;
import net.miginfocom.layout.UnitValue;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.swing.MigLayout.model.MigDimensionInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.ui.ErrorMessageTextField;

public final class DimensionUnitValueField {
    private final String m_propertyName;
    private final Listener m_listener;
    private MigDimensionInfo m_dimension;
    private final Button m_checkButton;
    private final ErrorMessageTextField m_field;
    private final Text m_textWidget;
    private boolean m_updatingDimension;
    private final Listener m_modifyListener = new Listener(){

        public void handleEvent(Event e) {
            DimensionUnitValueField.this.toDimension(DimensionUnitValueField.this.m_textWidget.getText());
        }
    };

    public DimensionUnitValueField(Composite parent, String labelText, String propertyName, Listener listener) {
        this.m_propertyName = StringUtils.capitalize((String)propertyName);
        this.m_listener = listener;
        this.m_checkButton = new Button(parent, 32);
        this.m_checkButton.setText(labelText);
        this.m_checkButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (DimensionUnitValueField.this.m_checkButton.getSelection()) {
                    DimensionUnitValueField.this.m_textWidget.setEnabled(true);
                    DimensionUnitValueField.this.setText("100px");
                    DimensionUnitValueField.this.toDimension(DimensionUnitValueField.this.m_textWidget.getText());
                } else {
                    DimensionUnitValueField.this.m_textWidget.setEnabled(false);
                    DimensionUnitValueField.this.setText("");
                    DimensionUnitValueField.this.toDimension(null);
                }
            }
        });
        this.m_field = new ErrorMessageTextField(parent, 2048);
        GridDataFactory.create((Control)this.m_field.getLayoutControl()).grabH().fillH();
        this.m_textWidget = (Text)this.m_field.getControl();
        this.m_textWidget.addListener(24, this.m_modifyListener);
    }

    public void fromDimension(MigDimensionInfo dimension) {
        if (!this.m_updatingDimension) {
            this.m_dimension = dimension;
            try {
                String methodName = MessageFormat.format("get{0}", this.m_propertyName);
                UnitValue value = (UnitValue)ReflectionUtils.invokeMethod2((Object)this.m_dimension, (String)methodName);
                if (value == null) {
                    this.m_checkButton.setSelection(false);
                    this.m_textWidget.setEnabled(false);
                    this.setText("");
                } else {
                    this.m_checkButton.setSelection(true);
                    this.m_textWidget.setEnabled(true);
                    String text = this.m_dimension.getString(value);
                    if (!this.m_textWidget.getText().equals(text)) {
                        this.setText(text);
                    }
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private void toDimension(String s) {
        this.m_updatingDimension = true;
        try {
            try {
                String methodName = MessageFormat.format("set{0}", this.m_propertyName);
                ReflectionUtils.invokeMethod2((Object)this.m_dimension, (String)methodName, String.class, (Object)s);
                this.notifyModified(true);
                this.m_field.setErrorMessage(null);
            }
            catch (Throwable e) {
                this.notifyModified(false);
                this.m_field.setErrorMessage(e.getMessage());
                this.m_updatingDimension = false;
            }
        }
        finally {
            this.m_updatingDimension = false;
        }
    }

    private void notifyModified(boolean valid) {
        Event event = new Event();
        event.doit = valid;
        this.m_listener.handleEvent(event);
    }

    private void setText(String text) {
        if (!this.m_textWidget.getText().equals(text)) {
            this.m_textWidget.removeListener(24, this.m_modifyListener);
            try {
                this.m_textWidget.setText(text);
                this.m_field.setErrorMessage(null);
            }
            finally {
                this.m_textWidget.addListener(24, this.m_modifyListener);
            }
        }
    }
}

