/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.processable;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.text.java.AnonymousTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.AnonymousTypeProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.IProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessorManager;
import org.eclipse.recommenders.completion.rcp.processable.ProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.Proposals;
import org.eclipse.recommenders.utils.Checks;

public class ProcessableAnonymousTypeCompletionProposal
extends AnonymousTypeCompletionProposal
implements IProcessableProposal {
    private Map<IProposalTag, Object> tags = Maps.newHashMap();
    private ProposalProcessorManager mgr;
    private CompletionProposal coreProposal;
    private String lastPrefix;

    public ProcessableAnonymousTypeCompletionProposal(CompletionProposal coreProposal, JavaCompletionProposal uiProposal, JavaContentAssistInvocationContext context) throws JavaModelException {
        super(context.getProject(), context.getCompilationUnit(), context, coreProposal.getReplaceStart(), uiProposal.getReplacementLength(), String.valueOf(coreProposal.getCompletion()), uiProposal.getStyledDisplayString(), String.valueOf(coreProposal.getDeclarationSignature()), (IType)context.getProject().findElement(String.valueOf(coreProposal.getDeclarationKey()), null), uiProposal.getRelevance());
        this.coreProposal = coreProposal;
    }

    protected ProcessableAnonymousTypeCompletionProposal(IJavaProject jproject, ICompilationUnit cu, JavaContentAssistInvocationContext invocationContext, int start, int length, String constructorCompletion, StyledString displayName, String declarationSignature, IType superType, int relevance) {
        super(jproject, cu, invocationContext, start, length, constructorCompletion, displayName, declarationSignature, superType, relevance);
    }

    protected ProposalInfo getProposalInfo() {
        ProposalInfo info = super.getProposalInfo();
        if (info == null) {
            IJavaProject project = this.fInvocationContext.getProject();
            info = new AnonymousTypeProposalInfo(project, this.coreProposal);
            this.setProposalInfo(info);
        }
        return info;
    }

    public boolean isPrefix(String prefix, String completion) {
        this.lastPrefix = prefix;
        boolean res = this.mgr.prefixChanged(prefix) || super.isPrefix(prefix, completion);
        this.setTag(ProposalTag.IS_VISIBLE, res);
        return res;
    }

    @Override
    public String getPrefix() {
        return this.lastPrefix;
    }

    @Override
    public Optional<CompletionProposal> getCoreProposal() {
        return Optional.fromNullable((Object)this.coreProposal);
    }

    @Override
    public ProposalProcessorManager getProposalProcessorManager() {
        return this.mgr;
    }

    @Override
    public void setProposalProcessorManager(ProposalProcessorManager mgr) {
        this.mgr = mgr;
    }

    @Override
    public void setTag(IProposalTag key, Object value) {
        Checks.ensureIsNotNull((Object)key);
        if (value == null) {
            this.tags.remove(key);
        } else {
            this.tags.put(key, value);
        }
    }

    @Override
    public <T> Optional<T> getTag(IProposalTag key) {
        return Optional.fromNullable((Object)this.tags.get(key));
    }

    @Override
    public <T> Optional<T> getTag(String key) {
        return Proposals.getTag((ICompletionProposal)this, key);
    }

    @Override
    public <T> T getTag(IProposalTag key, T defaultValue) {
        Object res = this.tags.get(key);
        return (T)(res != null ? res : defaultValue);
    }

    @Override
    public <T> T getTag(String key, T defaultValue) {
        return (T)this.getTag(key).or(defaultValue);
    }

    @Override
    public ImmutableSet<IProposalTag> tags() {
        return ImmutableSet.copyOf(this.tags.keySet());
    }
}

