/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.utils;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.codeassist.InternalCompletionProposal;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.recommenders.rcp.utils.CompilerBindings;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.LogMessages;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Reflections;
import org.eclipse.recommenders.utils.names.IMethodName;

public final class ProposalUtils {
    private static final char[] INIT = "<init>".toCharArray();
    private static Field ORIGINAL_SIGNATURE = (Field)Reflections.getDeclaredField(InternalCompletionProposal.class, (String)"originalSignature").orNull();

    private ProposalUtils() {
        throw new IllegalStateException("Not meant to be instantiated");
    }

    private static char[] getSignature(CompletionProposal proposal) {
        char[] signature = null;
        try {
            if (ProposalUtils.canUseReflection(proposal)) {
                signature = (char[])ORIGINAL_SIGNATURE.get(proposal);
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_REFLECTION_FAILED, (Throwable)e, (Object[])new Object[]{ORIGINAL_SIGNATURE});
        }
        return signature != null ? signature : proposal.getSignature();
    }

    private static boolean canUseReflection(CompletionProposal proposal) {
        return proposal instanceof InternalCompletionProposal && ORIGINAL_SIGNATURE != null && ORIGINAL_SIGNATURE.isAccessible();
    }

    public static Optional<IMethodName> toMethodName(CompletionProposal proposal, LookupEnvironment env) {
        MethodBinding[] overloads;
        Preconditions.checkArgument((boolean)ProposalUtils.isKindSupported(proposal));
        ReferenceBinding declaringType = (ReferenceBinding)ProposalUtils.getDeclaringType(proposal, env).orNull();
        if (declaringType == null) {
            return Optional.absent();
        }
        char[] methodName = proposal.isConstructor() ? INIT : proposal.getName();
        try {
            overloads = declaringType.getMethods(methodName);
        }
        catch (AbortCompilation abortCompilation) {
            Logs.log((Logs.ILogMessage)org.eclipse.recommenders.internal.completion.rcp.LogMessages.LOG_ERROR_COMPILATION_FAILURE_PREVENTS_PROPOSAL_MATCHING, null, (Object[])new Object[]{proposal});
            return Optional.absent();
        }
        char[] proposalSignature = ProposalUtils.getSignature(proposal);
        char[] strippedProposalSignature = ProposalUtils.stripTypeParameters(proposalSignature);
        MethodBinding[] methodBindingArray = overloads;
        int n = overloads.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBinding overload = methodBindingArray[n2];
            char[] signature = CompletionEngine.getSignature((MethodBinding)overload);
            if (Arrays.equals(proposalSignature, signature)) {
                return CompilerBindings.toMethodName((MethodBinding)overload);
            }
            if (Arrays.equals(strippedProposalSignature, signature)) {
                return CompilerBindings.toMethodName((MethodBinding)overload);
            }
            ++n2;
        }
        return Optional.absent();
    }

    private static boolean isKindSupported(CompletionProposal proposal) {
        switch (proposal.getKind()) {
            case 6: {
                return true;
            }
            case 24: {
                return true;
            }
            case 7: {
                return true;
            }
            case 26: {
                return true;
            }
        }
        return false;
    }

    private static char[] stripTypeParameters(char[] proposalSignature) {
        char[][] parameterTypes;
        StringBuilder sb = new StringBuilder();
        sb.append(proposalSignature, 0, ArrayUtils.indexOf((char[])proposalSignature, (char)'('));
        sb.append('(');
        char[][] cArray = parameterTypes = Signature.getParameterTypes((char[])proposalSignature);
        int n = parameterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            char[] parameterType = cArray[n2];
            sb.append(Signature.getTypeErasure((char[])parameterType));
            ++n2;
        }
        sb.append(')');
        char[] returnType = Signature.getReturnType((char[])proposalSignature);
        sb.append(Signature.getTypeErasure((char[])returnType));
        char[][] exceptionTypes = Signature.getThrownExceptionTypes((char[])proposalSignature);
        if (exceptionTypes.length > 0) {
            sb.append('^');
            char[][] cArray2 = exceptionTypes;
            int n3 = exceptionTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                char[] exceptionType = cArray2[n4];
                sb.append(exceptionType);
                ++n4;
            }
        }
        return sb.toString().toCharArray();
    }

    private static Optional<ReferenceBinding> getDeclaringType(CompletionProposal proposal, LookupEnvironment env) {
        char[] declarationSignature = proposal.getDeclarationSignature();
        if (declarationSignature[0] != 'L') {
            return Optional.absent();
        }
        int semicolonIndex = ArrayUtils.indexOf((char[])declarationSignature, (char)';');
        int greaterThanIndex = ArrayUtils.indexOf((char[])declarationSignature, (char)'<');
        if (greaterThanIndex == -1) {
            greaterThanIndex = Integer.MAX_VALUE;
        }
        char[][] compoundName = CharOperation.splitOn((char)'.', (char[])declarationSignature, (int)1, (int)Math.min(semicolonIndex, greaterThanIndex));
        return ProposalUtils.lookup(env, compoundName);
    }

    private static Optional<ReferenceBinding> lookup(LookupEnvironment env, char[][] compoundName) {
        ReferenceBinding result = env.getType(compoundName);
        if (result instanceof ProblemReferenceBinding) {
            result = (ReferenceBinding)Checks.cast((Object)((ProblemReferenceBinding)result).closestMatch());
        }
        return Optional.fromNullable((Object)result);
    }
}

