<?php

namespace Topxia\Api\Resource\Classroom;

use AppBundle\Common\ArrayToolkit;
use Silex\Application;
use Symfony\Component\HttpFoundation\Request;
use Topxia\Api\Resource\BaseResource;
use Topxia\Service\Common\ServiceKernel;

class Members extends BaseResource
{
    public function get(Application $app, Request $request, $classroomId)
    {
        $conditions = ['classroomId' => $classroomId];
        $start = $request->query->get('start', 0);
        $limit = $request->query->get('limit', 10);

        $total = $this->getClassroomService()->searchMemberCount($conditions);
        $members = $this->getClassroomService()->searchMembers($conditions, ['createdTime' => 'DESC'], $start, $limit);

        $users = $this->getUserService()->findUsersByIds(ArrayToolkit::column($members, 'userId'));
        $userProfiles = $this->getUserService()->findUserProfilesByIds(ArrayToolkit::column($members, 'userId'));

        foreach ($users as &$user) {
            $user['truename'] = $userProfiles[$user['id']]['truename'];
        }

        foreach ($members as &$member) {
            $member['user'] = empty($users[$member['userId']]) ? null : $users[$member['userId']];
        }

        $members = $this->wrap($this->filter($members), $total);

        foreach ($members['resources'] as $key => $resource) {
            $members['resources'][$key] = ArrayToolkit::parts($resource, $this->filterMemberColumn());
            unset($members['resources'][$key]['user']['uuid']);
        }

        return $members;
    }

    private function filterMemberColumn()
    {
        return [
            'id',
            'user',
            'classroomId',
            'userId',
        ];
    }

    public function filter($res)
    {
        return $this->multicallFilter('Classroom/Member', $res);
    }

    protected function getUserService()
    {
        return ServiceKernel::instance()->createService('User:UserService');
    }

    protected function getClassroomService()
    {
        return $this->getServiceKernel()->createService('Classroom:ClassroomService');
    }
}
