<?php

namespace Topxia\Api\Resource\Course;

use AppBundle\Common\ArrayToolkit;
use Silex\Application;
use Symfony\Component\HttpFoundation\Request;
use Topxia\Api\Resource\BaseResource;
use Topxia\Service\Common\ServiceKernel;

class Members extends BaseResource
{
    public function get(Application $app, Request $request, $courseId)
    {
        $conditions = ['courseId' => $courseId];
        $start = $request->query->get('start', 0);
        $limit = $request->query->get('limit', 10);

        //需要区分讲师吗？8.0以前版本没有
        $total = $this->getCourseMemberService()->countMembers($conditions);
        $members = $this->getCourseMemberService()->searchMembers(
            $conditions,
            ['createdTime' => 'DESC'],
            $start,
            $limit
        );
        $members = $this->assemblyMembers($members);

        $members = $this->wrap($this->filter($members), $total);

        foreach ($members['resources'] as $key => $resource) {
            $members['resources'][$key] = ArrayToolkit::parts($resource, $this->filterMemberColumn());
        }

        return $members;
    }

    private function filterMemberColumn()
    {
        return [
            'id',
            'courseId',
            'deadLine',
            'lastViewTime',
            'user',
            'access',
        ];
    }

    public function filter($res)
    {
        return $this->multicallFilter('Course/Member', $res);
    }

    protected function assemblyMembers($members)
    {
        $users = $this->getUserService()->findUsersByIds(ArrayToolkit::column($members, 'userId'));
        $courses = $this->getCourseService()->findCoursesByIds(ArrayToolkit::column($members, 'courseId'));
        $userProfiles = $this->getUserService()->findUserProfilesByIds(ArrayToolkit::column($members, 'userId'));

        foreach ($users as &$user) {
            $user['truename'] = $userProfiles[$user['id']]['truename'];
        }

        foreach ($members as &$member) {
            if (empty($member['updatedTime'])) {
                $member['updatedTime'] = $member['createdTime'];
            }
            $member['user'] = empty($users[$member['userId']]) ? null : $users[$member['userId']];
            $member['course'] = empty($courses[$member['courseId']]) ? null : $courses[$member['courseId']];
        }

        return $members;
    }

    protected function getUserService()
    {
        return ServiceKernel::instance()->createService('User:UserService');
    }

    protected function getCourseService()
    {
        return $this->getServiceKernel()->createService('Course:CourseService');
    }

    protected function getCourseMemberService()
    {
        return $this->getServiceKernel()->createService('Course:MemberService');
    }
}
