<?php

namespace ApiBundle\Api\Resource\Classroom;

use ApiBundle\Api\Annotation\ApiConf;
use ApiBundle\Api\Annotation\ResponseFilter;
use ApiBundle\Api\ApiRequest;
use ApiBundle\Api\Resource\AbstractResource;
use AppBundle\Common\ArrayToolkit;
use Biz\Classroom\Service\ClassroomService;

class ClassroomCourse extends AbstractResource
{
    public function search(ApiRequest $request, $classroomId)
    {
        $courses = $this->getClassroomService()->findCoursesByClassroomId($classroomId);

        $this->getOCUtil()->multiple($courses, ['courseSetId'], 'courseSet');
        $this->getOCUtil()->multiple($courses, ['creator', 'teacherIds']);

        foreach ($courses as $key => $course) {
            $courses[$key] = ArrayToolkit::parts($course, $this->filterCourseColumn());
        }

        return $courses;
    }

    private function filterCourseColumn()
    {
        return [
            'id',
            'title',
            'summary',
            'studentNum',
            'parentId',
            'audiences',
            'rating',
            'originPrice',
            'learnMode',
            'compulsoryTaskNum',
            'isFree',
            'taskNum',
            'tryLookable',
            'vipLevelId',
            'publishedTaskNum',
            'enableFinish',
            'services',
            'teachers',
            'courseSet',
            'learningExpiryDate',
            'price',
            'price2',
            'originPrice2',
            'access',
            'isAudioOn',
            'expiryMode',
            'expiryDays',
            'status',
        ];
    }

    /**
     * @return ClassroomService
     */
    private function getClassroomService()
    {
        return $this->service('Classroom:ClassroomService');
    }
}
