<?php

namespace ApiBundle\Api\Resource\Classroom;

use ApiBundle\Api\Resource\Filter;
use ApiBundle\Api\Util\AssetHelper;

class ClassroomCourseFilter extends Filter
{
    protected $publicFields = array(
        'id', 'title', 'learnMode', 'expiryMode', 'expiryDays', 'summary', 'audiences', 'status', 'isFree', 'price', 'vipLevelId', 'tryLookable', 'services', 'taskNum', 'studentNum', 'parentId', 'rating', 'originPrice', 'enableFinish', 'compulsoryTaskNum', 'courseSet', 'teachers'
    );

    protected function publicFields(&$data)
    {
        if (!empty($data['courseSet'])) {
           $this->transformCover($data['courseSet']['cover']);
        }
    }

    private function transformCover(&$cover)
    {
        $cover['small'] = AssetHelper::getFurl(empty($cover['small']) ? '' : $cover['small'], 'course.png');
        $cover['middle'] = AssetHelper::getFurl(empty($cover['middle']) ? '' : $cover['middle'], 'course.png');
        $cover['large'] = AssetHelper::getFurl(empty($cover['large']) ? '' : $cover['large'], 'course.png');
    }
}
