<?php

namespace ApiBundle\Api\Resource\TeacherLiveCourse;

use ApiBundle\Api\Annotation\ApiConf;
use ApiBundle\Api\ApiRequest;
use ApiBundle\Api\Resource\AbstractResource;
use ApiBundle\Api\Exception\ErrorCode;
use Symfony\Component\HttpKernel\Exception\BadRequestHttpException;

class TeacherLiveCourse extends AbstractResource
{
    /**
     * @ApiConf(isRequiredAuth=false)
     */
    public function search(ApiRequest $request)
    {
        $conditions = $request->query->all();
        if (empty($conditions['startTime_GE']) || empty($conditions['endTime_LT'])) {
            throw new BadRequestHttpException('Params missing', null, ErrorCode::INVALID_ARGUMENT);
        }
        $user = $this->getCurrentUser();
        $liveCourses = $this->getCourseService()->findLiveCourse($conditions, $user['id'], 'teacher');
        foreach ($liveCourses as &$liveCourse) {
            $liveCourse['url'] = $this->generateUrl('course_task_show', array(
                'courseId' => $liveCourse['courseId'],
                'id' => $liveCourse['taskId'],
            ));
        }
        $openLiveCourses = $this->getOpenCourseService()->findOpenLiveCourse($conditions, $user['id']);
        foreach ($openLiveCourses as &$openLiveCourse) {
            $openLiveCourse['url'] = $this->generateUrl('open_course_show', array(
                'courseId' => $openLiveCourse['id'],
            ));
        }

        return array('data' => array_merge($liveCourses, $openLiveCourses));
    }

    /**
     * @return OpenCourseService
     */
    private function getOpenCourseService()
    {
        return $this->service('OpenCourse:OpenCourseService');
    }

    /**
     * @return CourseService
     */
    private function getCourseService()
    {
        return $this->service('Course:CourseService');
    }
}
