<?php

namespace AppBundle\Common;

class ChangelogToolkit
{
    public static function parseSingleChangelog($changelogStr)
    {
        $result = [
            'items' => [],
        ];
        $pattern = "/^(?:\S|\s)*((?:[1-9]\d|[1-9])(?:\.(?:[1-9]\d|\d)){2})\s*(?:\(|（)(\S*)(?:\)|）)\s*/";
        preg_match($pattern, $changelogStr, $metas);
        if (!empty($metas)) {
            $result['version'] = trim($metas['1']);
            $result['date'] = trim($metas['2']);
        }

        $spiltPattern = '/'.PHP_EOL.'/';
        $changelogArr = preg_split($spiltPattern, $changelogStr, -1, PREG_SPLIT_NO_EMPTY);
        unset($changelogArr[0]);
        unset($changelogArr[1]);
        $result['items'] = array_values($changelogArr);

        return $result;
    }
}
