<?php

namespace AppBundle\Controller\Admin;

use AppBundle\Common\Exception\AccessDeniedException;
use AppBundle\Common\TreeToolkit;
use AppBundle\Common\ArrayToolkit;
use Biz\Org\Service\OrgService;
use Symfony\Component\HttpFoundation\Request;
use Topxia\Service\Common\ServiceKernel;

class OrgManageController extends BaseController
{
    public function indexAction(Request $request)
    {
        $user = $this->getUser();
        $org = $this->getOrgService()->getOrg($user['orgId']);
        $orgs = $this->getOrgService()->findOrgsByPrefixOrgCode();

        $treeOrgs = TreeToolkit::makeTree($orgs, 'seq', $org['parentId']);
        $userIds = ArrayToolkit::column($orgs, 'createdUserId');
        $createdUsers = $this->getUserService()->findUsersByIds($userIds);

        return $this->render(
            'admin/org-manage/index.html.twig',
            array(
                'orgs' => $treeOrgs,
                'createdUsers' => $createdUsers,
            )
        );
    }

    public function createAction(Request $request)
    {
        if ('POST' == $request->getMethod()) {
            $org = $request->request->all();
            $this->getOrgService()->createOrg($org);

            return $this->redirect($this->generateUrl('admin_org'));
        }

        $parentId = $request->query->get('parentId', 0);
        $org = array('parentId' => $parentId);

        return $this->render('admin/org-manage/modal.html.twig', array('org' => $org));
    }

    public function updateAction(Request $request, $id)
    {
        $org = $this->getOrgService()->getOrg($id);
        $manageOrgIds = $this->getManagePermissionService()->findUserManageOrgIdsByUserId($this->getCurrentUser()->getId());

        if ('POST' == $request->getMethod()) {
            $updateOrg = $request->request->all();
            $parentOrg = $this->getOrgService()->getOrg($org['parentId']);
            $updateOrg = $this->checkChangeParentOrg($updateOrg, $parentOrg, $manageOrgIds);
            $org = $this->getOrgService()->updateOrg($id, $updateOrg);
            if ($org) {
                return $this->createJsonResponse(array('status' => 'success', 'org' => array('id' => $org['id'], 'parentId' => $org['parentId'], 'changeParent' => empty($updateOrg['newParentOrgCode']) ? 0 : 1)));
            }

            return $this->createJsonResponse(array('status' => 'error'));
        }

        return $this->render(
            'admin/org-manage/modal.html.twig',
            array(
                'org' => $org,
                'manageOrgIds' => $manageOrgIds,
            )
        );
    }

    public function deleteAction(Request $request, $id)
    {
        $this->getOrgService()->deleteOrg($id);

        return $this->createJsonResponse(array('status' => 'success', 'orgId' => $id));
    }

    public function checkCodeAction(Request $request)
    {
        $value = $request->query->get('value');
        $exclude = $request->query->get('exclude');

        $isAvaliable = $this->getOrgService()->isCodeAvaliable($value, $exclude);

        if ($isAvaliable) {
            $response = array('success' => true, 'message' => '');
        } else {
            $response = array('success' => false, 'message' => ServiceKernel::instance()->trans('admin.post.message.code_exist'));
        }

        return $this->createJsonResponse($response);
    }

    public function checkNameAction(Request $request)
    {
        $parentId = $request->query->get('parentId');
        $name = $request->query->get('value');
        $exclude = $request->query->get('exclude');
        $isAvaliable = $this->getOrgService()->isNameAvaliable($name, $parentId, $exclude);

        if ($isAvaliable) {
            $response = array('success' => true, 'message' => '');
        } else {
            $response = array('success' => false, 'message' => '名称已被占用,请换一个');
        }

        return $this->createJsonResponse($response);
    }

    public function sortAction(Request $request)
    {
        $ids = $request->request->get('ids');
        $this->getOrgService()->sortOrg($ids);

        return $this->createJsonResponse(true);
    }

    /**
     * @param  Request
     * @param  [string]  module 要更新的模块名
     *
     * @return [type]
     */
    public function batchUpdateAction(Request $request, $module)
    {
        if ('POST' == $request->getMethod()) {
            $ids = $request->request->get('ids');
            $orgCode = $request->request->get('orgCode');

            $orgModules = $this->container->get('corporatetraining.extension.manager')->getOrgModules();

            $this->getOrgService()->batchUpdateOrg($orgModules[$module], $ids, $orgCode);

            return $this->createJsonResponse(true);
        }

        return $this->render('org/batch-update-org-modal.html.twig', array('module' => $module));
    }

    /**
     * @return OrgService
     */
    protected function getOrgService()
    {
        return $this->createService('Org:OrgService');
    }

    /**
     * @param array $updateOrg
     * @param array $parentOrg
     * @param $manageOrgIds
     *
     * @return array
     */
    protected function checkChangeParentOrg(array $updateOrg, $parentOrg, $manageOrgIds)
    {
        if (isset($updateOrg['orgCode']) && $parentOrg['orgCode'] != $updateOrg['orgCode']) {
            $codes = array_filter(explode('.', $updateOrg['orgCode']));
            $intersectOrgId = array_intersect($manageOrgIds, $codes);
            if (empty($intersectOrgId)) {
                throw new AccessDeniedException('你无法设置该父级，请确认你的管理范围!');
            }
            $newParentOrg = $this->getOrgService()->getOrgByOrgCode($updateOrg['orgCode']);
            $updateOrg['parentId'] = $newParentOrg['id'];
            $updateOrg['newParentOrgCode'] = $newParentOrg['orgCode'];
        }
        unset($updateOrg['orgCode']);

        return $updateOrg;
    }
}
