<?php

namespace AppBundle\Controller\Admin;

use AppBundle\Common\Paginator;
use Codeages\Biz\Framework\Queue\Service\QueueService;
use Symfony\Component\HttpFoundation\Request;

class QueueController extends BaseController
{
    public function queueJobsAction(Request $request)
    {
        $count = $this->getQueueService()->countJobs([]);

        $paginator = new Paginator(
            $request,
            $count,
            20
        );

        $jobs = $this->getQueueService()->searchJobs(
            [],
            ['id' => 'ASC'],
            $paginator->getOffsetCount(),
            $paginator->getPerPageCount()
        );

        return $this->render(
            'admin/queue/index.html.twig',
            [
                'jobs' => $jobs,
                'paginator' => $paginator,
            ]
        );
    }

    public function failedJobsAction(Request $request)
    {
        $count = $this->getQueueService()->countFailedJobs([]);

        $paginator = new Paginator(
            $request,
            $count,
            20
        );

        $jobs = $this->getQueueService()->searchFailedJobs(
            [],
            ['failed_time' => 'desc'],
            $paginator->getOffsetCount(),
            $paginator->getPerPageCount()
        );

        return $this->render(
            'admin/queue/failed-logs.html.twig',
            [
                'jobs' => $jobs,
                'paginator' => $paginator,
            ]
        );
    }

    public function failedJobAction(Request $request, $id)
    {
        $failedJob = $this->getQueueService()->getFailedJob($id);

        return $this->render(
            'admin/queue/failed-log-modal.html.twig',
            [
                'failedJob' => $failedJob,
            ]
        );
    }

    /**
     * @return QueueService
     */
    protected function getQueueService()
    {
        return $this->createService('Queue:QueueService');
    }
}
