<?php

namespace Biz;

use AppBundle\System;
use Codeages\Biz\Framework\Context\Biz;
use Pimple\ServiceProviderInterface;
use Pimple\Container;

class DefaultSdkProvider implements ServiceProviderInterface
{
    public function register(Container $biz)
    {
        $that = $this;
        $biz['qiQiuYunSdk.drp'] = function ($biz) use ($that) {
            $service = null;
            $sdk = $that->generateSdk($biz, $that->getDrpConfig($biz));
            if (!empty($sdk)) {
                $service = $sdk->getDrpService();
            }

            return $service;
        };

        $biz['qiQiuYunSdk.xapi'] = function ($biz) use ($that) {
            $service = null;
            $sdk = $that->generateSdk($biz, $that->getXAPIConfig($biz));
            if (!empty($sdk)) {
                $service = $sdk->getXAPIService();
            }

            return $service;
        };

        $biz['qiQiuYunSdk.play'] = function ($biz) use ($that) {
            $service = null;
            $sdk = $that->generateSdk($biz, []);
            if (!empty($sdk)) {
                $service = $sdk->getPlayService();
            }

            return $service;
        };

        $biz['qiQiuYunSdk.sms'] = function ($biz) use ($that) {
            $service = null;

            $sdk = $that->generateSdk($biz, []);
            if (!empty($sdk)) {
                $service = $sdk->getSmsService();
            }

            return $service;
        };
    }

    public function generateSdk($biz, $serviceConfig)
    {
        $setting = $biz->service('System:SettingService');

        $storageSetting = $setting->get('storage', []);

        $sdk = null;
        if (!empty($storageSetting['cloud_access_key']) && !empty($storageSetting['cloud_secret_key'])) {
            $sdk = new \QiQiuYun\SDK\QiQiuYunSDK(
                [
                    'access_key' => $storageSetting['cloud_access_key'],
                    'secret_key' => $storageSetting['cloud_secret_key'],
                    'service' => $serviceConfig,
                ]
            );
        }

        return $sdk;
    }

    public function getDrpConfig($biz)
    {
        $setting = $biz->service('System:SettingService');
        $developerSetting = $setting->get('developer', []);

        if (!empty($developerSetting['distributor_server'])) {
            $urlSegs = explode('://', $developerSetting['distributor_server']);
            if (2 == count($urlSegs)) {
                $hostUrl = $urlSegs[1];
            }
        }

        if (empty($hostUrl)) {
            $hostUrl = '';
        }

        return ['drp' => ['host' => $hostUrl]];
    }

    public function getXAPIConfig(Biz $biz)
    {
        $settingService = $biz->service('System:SettingService');
        $siteSettings = $settingService->get('site', []);
        $xapiSetting = $settingService->get('xapi', []);
        $pushUrl = !empty($xapiSetting['push_url']) ? $xapiSetting['push_url'] : 'lrs.qiqiuyun.net/v1/xapi/';
        $pushUrl = ltrim($pushUrl, ' ');
        $pushUrl = rtrim($pushUrl, '/');
        $pushUrl = ltrim($pushUrl, 'http://');
        $pushUrl = ltrim($pushUrl, 'https://');
        $siteName = empty($siteSettings['name']) ? 'none' : $siteSettings['name'];
        $siteUrl = empty($siteSettings['url']) ? '' : $siteSettings['url'];

        return [
            'xapi' => [
                'host' => $pushUrl,
                'school_name' => $siteName,
                'school_url' => $siteUrl,
                'school_version' => System::VERSION,
            ],
        ];
    }
}
