<?php

namespace Biz\File\FireWall;

use CertificatePlugin\Biz\Certificate\Service\CertificateMemberService;

class CertificateFileFireWall extends BaseFireWall implements FireWallInterface
{
    public function canAccess($attachment)
    {
        $user = $this->getCurrentUser();
        if ($user->isAdmin()) {
            return true;
        }

        if ($user->isSuperAdmin()) {
            return true;
        }

        if ($user->hasPermission('admin_train_certificate_manage_list')) {
            return true;
        }

        $member = $this->getCertificateMemberService()->getCertificateMember($attachment['targetId']);
        if ('none' == $member['status'] && $user->getId() == $member['userId']) {
            return true;
        }

        return false;
    }

    /**
     * @return CertificateMemberService
     */
    protected function getCertificateMemberService()
    {
        return $this->biz->service('CertificatePlugin:Certificate:CertificateMemberService');
    }
}
