<?php

namespace Biz\File\FireWall;

class OfflineCourseTemplateFileFireWall extends BaseFireWall implements FireWallInterface
{
    public function canAccess($attachment)
    {
        $user = $this->getCurrentUser();
        if ($user->isAdmin()) {
            return true;
        }

        if ($user->isSuperAdmin()) {
            return true;
        }

        if ($user->hasPermission('admin_offline_course_manage')) {
            return true;
        }

        return false;
    }
}
