<?php

namespace Biz\File\FireWall;

class ProjectPlaningFileFireWall extends BaseFireWall implements FireWallInterface
{
    public function canAccess($attachment)
    {
        $user = $this->getCurrentUser();
        if ($user->isAdmin()) {
            return true;
        }

        if ($user->isSuperAdmin()) {
            return true;
        }

        if ($user->hasPermission('admin_project_plan_manage')) {
            return true;
        }

        return false;
    }
}
