<?php

namespace CorporateTrainingBundle\Biz\AdvancedMemberSelect;

use AppBundle\Common\ArrayToolkit;

class ClassroomMemberSelect extends AbstractMemberSelect
{
    protected $advancedMemberSelectType = 'classroom_member';

    public function canSelect($targetId)
    {
        if (empty($targetId)) {
            return false;
        }

        return $this->getClassroomService()->canManageClassroom($targetId);
    }

    public function becomeMember($targetId, $userIds)
    {
        if (empty($userIds)) {
            return true;
        }

        return $this->getClassroomService()->batchBecomeStudent($targetId, $userIds);
    }

    protected function filterMembers($targetId, $userIds)
    {
        $members = $this->getClassroomService()->searchMembers(['userIds' => $userIds, 'classroomId' => $targetId], [], 0, count($userIds), ['userId']);
        $existUserIds = ArrayToolkit::column($members, 'userId');

        return array_diff($userIds, $existUserIds);
    }

    protected function sendNotification($userIds, $targetId, $dingTalkNotificationSetting)
    {
        $resource = $this->biz->offsetGet('resource_notification.classroom');
        $resource->onAdminSelectUsers($targetId, $userIds, $dingTalkNotificationSetting);
    }

    /**
     * @return \Biz\Classroom\Service\Impl\ClassroomServiceImpl
     */
    protected function getClassroomService()
    {
        return $this->createService('Classroom:ClassroomService');
    }

    protected function sendEnrollNotification($userIds, $targetId)
    {
        // TODO: Implement sendEnrollNotification() method.
    }
}
