<?php

namespace CorporateTrainingBundle\Biz\AdvancedMemberSelect;

use AppBundle\Common\ArrayToolkit;
use CorporateTrainingBundle\Biz\Course\Service\CourseSetService;

class CourseMemberSelect extends AbstractMemberSelect
{
    protected $advancedMemberSelectType = 'course_member';

    public function canSelect($targetId)
    {
        if (empty($targetId)) {
            return false;
        }

        return $this->getCourseService()->canManageCourse($targetId);
    }

    public function becomeMember($targetId, $userIds)
    {
        if (empty($userIds)) {
            return true;
        }

        return $this->getCourseMemberService()->batchBecomeStudents($targetId, $userIds);
    }

    protected function filterMembers($targetId, $userIds)
    {
        $members = $this->getCourseMemberService()->searchMembers(['userIds' => $userIds, 'courseId' => $targetId], [], 0, count($userIds), ['userId']);
        $existUserIds = ArrayToolkit::column($members, 'userId');

        return array_diff($userIds, $existUserIds);
    }

    protected function sendNotification($userIds, $targetId, $dingTalkNotificationSetting)
    {
        $resource = $this->biz->offsetGet('resource_notification.course');
        $resource->onAdminSelectUsers($targetId, $userIds, $dingTalkNotificationSetting);
    }

    /**
     * @return \CorporateTrainingBundle\Biz\Course\Service\Impl\CourseServiceImpl
     */
    protected function getCourseService()
    {
        return $this->createService('CorporateTrainingBundle:Course:CourseService');
    }

    /**
     * @return CourseSetService
     */
    protected function getCourseSetService()
    {
        return $this->createService('CorporateTrainingBundle:Course:CourseSetService');
    }

    /**
     * @return \Biz\Course\Service\Impl\MemberServiceImpl
     */
    protected function getCourseMemberService()
    {
        return $this->createService('Course:MemberService');
    }

    protected function sendEnrollNotification($userIds, $targetId)
    {
        // TODO: Implement sendEnrollNotification() method.
    }
}
