<?php

namespace CorporateTrainingBundle\Biz\AdvancedMemberSelect;

use AppBundle\Common\ArrayToolkit;
use CorporateTrainingBundle\Biz\OfflineActivity\Service\MemberService;
use CorporateTrainingBundle\Biz\OfflineActivity\Service\OfflineActivityService;

class OfflineActivitySelect extends AbstractMemberSelect
{
    protected $advancedMemberSelectType = 'offlineActivity_member';

    protected $enrollType = 'offlineActivity';

    public function canSelect($activityId)
    {
        if (empty($activityId)) {
            return false;
        }

        return $this->getOfflineActivityService()->canManageOfflineActivity($activityId);
    }

    public function becomeMember($targetId, $userIds)
    {
        if (empty($userIds)) {
            return true;
        }

        return $this->getOfflineActivityMemberService()->batchBecomeMember($targetId, $userIds);
    }

    protected function filterMembers($targetId, $userIds)
    {
        $members = $this->getOfflineActivityMemberService()->searchMembers(['userIds' => $userIds, 'activityId' => $targetId], [], 0, count($userIds), ['userId']);
        $existUserIds = ArrayToolkit::column($members, 'userId');

        return array_diff($userIds, $existUserIds);
    }

    protected function sendNotification($userIds, $targetId, $dingTalkNotificationSetting)
    {
        $resource = $this->biz->offsetGet('resource_notification.offline_activity');
        $resource->onAdminSelectUsers($targetId, $userIds, $dingTalkNotificationSetting);
    }

    /**
     * @return OfflineActivityService
     */
    protected function getOfflineActivityService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineActivity:OfflineActivityService');
    }

    /**
     * @return MemberService
     */
    protected function getOfflineActivityMemberService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineActivity:MemberService');
    }

    protected function sendEnrollNotification($userIds, $targetId)
    {
        $resource = $this->biz->offsetGet('resource_notification.offline_activity');
        $resource->onOfflineActivityBatchPass($targetId, $userIds);
    }
}
