<?php

namespace CorporateTrainingBundle\Biz\AdvancedMemberSelect;

use AppBundle\Common\ArrayToolkit;

class ProjectPlanMemberSelect extends AbstractMemberSelect
{
    protected $advancedMemberSelectType = 'project_plan_member';

    protected $enrollType = 'projectPlan';

    public function canSelect($targetId)
    {
        if (empty($targetId)) {
            return false;
        }

        return $this->getProjectPlanService()->canManageProjectPlan($targetId);
    }

    public function becomeMember($targetId, $userIds)
    {
        if (empty($userIds)) {
            return true;
        }

        $result = $this->getProjectPlanMemberService()->batchBecomeMember($targetId, $userIds);

        return $result;
    }

    protected function filterMembers($targetId, $userIds)
    {
        $members = $this->getProjectPlanMemberService()->searchProjectPlanMembers(['userIds' => $userIds, 'projectPlanId' => $targetId], [], 0, count($userIds), ['userId']);
        $existUserIds = ArrayToolkit::column($members, 'userId');

        return array_diff($userIds, $existUserIds);
    }

    protected function sendNotification($userIds, $targetId, $dingTalkNotificationSetting)
    {
        $resource = $this->biz->offsetGet('resource_notification.project_plan');
        $resource->onAdminSelectUsers($targetId, $userIds, $dingTalkNotificationSetting);
    }

    /**
     * @return \CorporateTrainingBundle\Biz\ProjectPlan\Service\Impl\ProjectPlanServiceImpl
     */
    protected function getProjectPlanService()
    {
        return $this->createService('CorporateTrainingBundle:ProjectPlan:ProjectPlanService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\ProjectPlan\Service\Impl\MemberServiceImpl
     */
    protected function getProjectPlanMemberService()
    {
        return $this->createService('CorporateTrainingBundle:ProjectPlan:MemberService');
    }

    protected function sendEnrollNotification($userIds, $targetId)
    {
        $resource = $this->biz->offsetGet('resource_notification.project_plan');
        $resource->onPassProjectPlanApplies($targetId, $userIds);
    }
}
