<?php

namespace CorporateTrainingBundle\Biz\Attachment;

use CorporateTrainingBundle\Biz\Enroll\Service\EnrollRecordService;
use OfflineCourseProPlugin\Biz\OfflineClass\Service\OfflineClassService;

class OfflineClassEnrollAttachment extends BaseAttachment
{
    public function canOperate($fileId, $type = '')
    {
        $user = $this->getCurrentUser();
        $fileUsed = $this->getUploadFileService()->getUseFile($fileId);

        if (empty($fileUsed) && 'delete' == $type) {
            return true;
        }

        if (!in_array($fileUsed['targetType'], array('offline.Class.enroll', 'offlineClass.material1', 'offlineClass.material2', 'offlineClass.material3'))) {
            return false;
        }

        $record = $this->getEnrollRecordService()->getEnrollRecord($fileUsed['targetId']);

        if ($this->canManageProjectPlan($record['targetId'])) {
            return true;
        }

        if ($user['id'] == $record['userId'] && 'download' != $type) {
            return true;
        }

        return false;
    }

    public function canManageProjectPlan($classId)
    {
        return $this->getOfflineClassService()->canManageClass($classId);
    }

    /**
     * @return \CorporateTrainingBundle\Biz\ProjectPlan\Service\Impl\MemberServiceImpl
     */
    protected function getProjectPlanMemberService()
    {
        return $this->createService('ProjectPlan:MemberService');
    }

    /**
     * @return EnrollRecordService
     */
    protected function getEnrollRecordService()
    {
        return $this->createService('CorporateTrainingBundle:Enroll:EnrollRecordService');
    }

    /**
     * @return OfflineClassService
     */
    protected function getOfflineClassService()
    {
        return $this->createService('OfflineCourseProPlugin:OfflineClass:OfflineClassService');
    }
}
