<?php

namespace CorporateTrainingBundle\Biz\Attachment;

use CorporateTrainingBundle\Biz\Enroll\Service\EnrollRecordService;

class ProjectPlanEnrollAttachment extends BaseAttachment
{
    public function canOperate($fileId, $type = '')
    {
        $user = $this->getCurrentUser();
        $fileUsed = $this->getUploadFileService()->getUseFile($fileId);

        if (empty($fileUsed) && 'delete' == $type) {
            return true;
        }

        if (!in_array($fileUsed['targetType'], array('project.plan.enroll', 'projectPlaning.material1', 'projectPlaning.material2', 'projectPlaning.material3'))) {
            return false;
        }

        $record = $this->getEnrollRecordService()->getEnrollRecord($fileUsed['targetId']);

        if ($this->canManageProjectPlan($record['targetId'])) {
            return true;
        }

        if ($user['id'] == $record['userId'] && 'download' != $type) {
            return true;
        }

        return false;
    }

    public function canManageProjectPlan($projectPlanId)
    {
        return $this->getProjectPlanService()->canManageProjectPlan($projectPlanId);
    }

    /**
     * @return \CorporateTrainingBundle\Biz\ProjectPlan\Service\Impl\MemberServiceImpl
     */
    protected function getProjectPlanMemberService()
    {
        return $this->createService('ProjectPlan:MemberService');
    }

    /**
     * @return EnrollRecordService
     */
    protected function getEnrollRecordService()
    {
        return $this->createService('CorporateTrainingBundle:Enroll:EnrollRecordService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\ProjectPlan\Service\Impl\ProjectPlanServiceImpl
     */
    protected function getProjectPlanService()
    {
        return $this->createService('ProjectPlan:ProjectPlanService');
    }
}
