<?php

namespace CorporateTrainingBundle\Biz\Course\Dao\Impl;

use Codeages\Biz\Framework\Dao\DynamicQueryBuilder;
use Biz\Course\Dao\Impl\CourseMemberDaoImpl as BaseCourseMemberDaoImpl;
use CorporateTrainingBundle\Biz\Course\Dao\CourseMemberDao;

class CourseMemberDaoImpl extends BaseCourseMemberDaoImpl implements CourseMemberDao
{
    public function findMembersByCourseIdsAndRole($courseIds, $role)
    {
        if (empty($courseIds)) {
            return [];
        }
        $marks = str_repeat('?,', count($courseIds) - 1).'?';

        $sql = "SELECT * FROM {$this->table} WHERE role = ? AND  courseId IN ({$marks}) ORDER BY seq, createdTime DESC";

        return $this->db()->fetchAll($sql, array_merge([$role], $courseIds));
    }

    public function getFinishedTimeByCourseIdAndUserId($courseId, $userId)
    {
        $sql = "SELECT finishedTime FROM {$this->table()} m ";
        $sql .= ' INNER JOIN course_v8 c ON m.courseId = c.id ';
        $sql .= 'WHERE m.courseId = ? AND m.userId = ? AND ';
        $sql .= 'm.learnedCompulsoryTaskNum >= c.compulsoryTaskNum ';

        return $this->db()->fetchColumn($sql, [$courseId, $userId]);
    }

    //获取课程的完成总人数
    public function getFinishedUserCount($conditions)
    {
        $builder = $this->_buildJoinQueryBuilder($conditions, 'AND m.learnedCompulsoryTaskNum = c.compulsoryTaskNum')
            ->select('count(m.id)');

        return $builder->execute()->fetchColumn() ?: 0;
    }

    protected function _buildJoinQueryBuilder($conditions, $joinConnections = '')
    {
        $conditions = array_filter($conditions, function ($value) {
            if ('' === $value || null === $value) {
                return false;
            }

            return true;
        });

        $builder = new DynamicQueryBuilder($this->db(), $conditions);
        $builder->from($this->table(), 'm')
            ->join('m', 'course_v8', 'c', 'm.courseId = c.id '.$joinConnections)
            ->andWhere('m.isLearned = :isLearned')
            ->andWhere('m.role = :role')
            ->andWhere('m.courseId = :courseId')
            ->andWhere('m.joinedType =:joinedType')
            ->andWhere('m.noteNum > :noteNumGreaterThan')
            ->andWhere('m.userId = :userId')
            ->andWhere('m.courseId = :courseId')
            ->andWhere('m.courseId IN ( :courseIds)')
            ->andWhere('m.userId IN ( :userIds)')
            ->andWhere('m.finishedTime > :finishedTime_GT')
            ->andWhere('c.type = :type')
            ->andWhere('c.parentId = :parentId')
            ->andWhere('c.serializeMode <> :excludeSerializeMode')
            ->andWhere('c.serializeMode = :serializeMode')
            ->andWhere('c.serializeMode IN ( :serializeModes)');

        return $builder;
    }

    public function declares()
    {
        $declares = parent::declares();
        array_push($declares['conditions'], 'learnedNum = :learnedNum');
        array_push($declares['conditions'], 'id IN ( :ids )');

        return $declares;
    }

    protected function applySqlParams($conditions, $sql)
    {
        $params = [];
        $conditions = array_filter($conditions, function ($value) {
            return !empty($value);
        });
        foreach ($conditions as $key => $value) {
            if (!is_array($value)) {
                $sql .= $key.' = ? AND ';
                array_push($params, $value);
            } else {
                $arguments = implode(',', $value);
                $sql .= $key.' IN ('.$arguments.') AND ';
            }
        }

        return [$sql, $params];
    }
}
