<?php

namespace CorporateTrainingBundle\Biz\Crontab;

use Biz\Crontab\SystemCrontabInitializer as BaseCrontabInitializer;

class SystemCrontabInitializer extends BaseCrontabInitializer
{
    const TRAINING_SOURCE_SYSTEM = 'TRAININGMAIN';

    public static function init()
    {
        parent::init();
        self::registerJobs();
        self::registerCTDefaultJobs();
    }

    protected static function registerJobs()
    {
        $jobMap = [
            'OfflineCourseTaskAutoAttendanceJob' => [
                'expression' => '*/60 * * * *',
                'class' => 'CorporateTrainingBundle\Biz\OfflineCourse\Job\OfflineCourseTaskAutoAttendanceJob',
            ],
            'SyncMaxUsersNumberJob' => [
                'expression' => '7 0 * * *',
                'class' => 'CorporateTrainingBundle\Biz\User\Job\SyncMaxUsersNumberJob',
            ],
        ];
        $defaultJob = [
            'source' => self::TRAINING_SOURCE_SYSTEM,
            'args' => [],
            'misfire_policy' => 'executing',
        ];

        foreach ($jobMap as $key => $job) {
            $count = self::getSchedulerService()->countJobs(['name' => $key, 'source' => self::TRAINING_SOURCE_SYSTEM]);
            if (0 == $count) {
                $job = array_merge($defaultJob, $job);
                $job['name'] = $key;
                self::getSchedulerService()->register($job);
            }
        }
    }

    protected static function registerCTDefaultJobs()
    {
        $count = self::getSchedulerService()->countJobs(['name' => 'CheckConvertStatusJob', 'source' => 'MAIN']);
        if (0 == $count) {
            self::getSchedulerService()->register(
                [
                    'name' => 'CheckConvertStatusJob',
                    'source' => 'MAIN',
                    'expression' => '*/15 * * * *',
                    'class' => 'Biz\File\Job\VideoMediaStatusUpdateJob',
                    'args' => [],
                    'misfire_policy' => 'missed',
                ]
            );
        }
    }
}
