<?php

namespace CorporateTrainingBundle\Biz\DefaultSearch;

use AppBundle\Common\ArrayToolkit;
use AppBundle\Common\Paginator;

class ThreadSearch extends AbstractSearch
{
    public function search($request, $keywords)
    {
        $conditions = $this->prepareSearchConditions($keywords);

        $threadNum = $this->getThreadService()->countThreads($conditions);

        $paginator = new Paginator(
            $request,
            $threadNum,
            10
        );

        $threads = $this->getThreadService()->searchThreads(
            $conditions,
            array('lastPostTime' => 'desc'),
            $paginator->getOffsetCount(),
            $paginator->getPerPageCount()
        );

        return array($threads, $paginator);
    }

    public function count($request, $keywords)
    {
        $conditions = $this->prepareSearchConditions($keywords);
        $threadNum = $this->getThreadService()->countThreads($conditions);

        return $threadNum;
    }

    protected function prepareSearchConditions($keywords)
    {
        $conditions = array(
            'title' => $keywords,
            'status' => 'open',
        );
        $groupIds = $this->findOpenGroupIdsInThreads($conditions);
        $conditions['groupIds'] = empty($groupIds) ? array(-1) : $groupIds;

        return $conditions;
    }

    protected function findOpenGroupIdsInThreads($conditions)
    {
        $allThreads = $this->getThreadService()->searchThreads($conditions, array('lastPostTime' => 'desc'), 0, PHP_INT_MAX, array('groupId'));
        $groupIds = ArrayToolkit::column($allThreads, 'groupId');
        $groupConditions = array(
            'ids' => $groupIds,
            'status' => 'open',
        );
        $openGroupIds = $this->getGroupService()->searchGroups($groupConditions, array(), 0, PHP_INT_MAX, array('id'));
        $groupIds = ArrayToolkit::column($openGroupIds, 'id');

        return $groupIds;
    }

    /**
     * @return \Biz\Group\Service\Impl\ThreadServiceImpl
     */
    protected function getThreadService()
    {
        return $this->createService('Group:ThreadService');
    }

    /**
     * @return \Biz\Group\Service\Impl\GroupServiceImpl
     */
    protected function getGroupService()
    {
        return $this->createService('Group:GroupService');
    }
}
