<?php

namespace CorporateTrainingBundle\Biz\DingTalk\Template;

use AppBundle\Common\ArrayToolkit;
use AppBundle\Common\Exception\InvalidArgumentException;

class EvaluationPushTemplate extends BaseTemplate implements DingTalkTemplateInterface
{
    protected $type = 'evaluation_push';

    protected $linkUrl = '';

    protected $markdownContent = '';

    protected $title = '评价反馈通知';

    /**
     * {@inheritdoc}
     */
    public function parse($options)
    {
        if (!ArrayToolkit::requireds($options, ['targetId', 'url', 'resourceTitle', 'startTime'])) {
            throw new InvalidArgumentException('Lack of required fields');
        }
        $imgUrl = $this->getBaseUrl().'/assets/img/dingtalk/survey.png';
        $this->linkUrl = isset($options['url']) ? $options['url'] : $this->getBaseUrl().'/';
        $this->markdownContent = "#### 评价反馈通知  \n  ";
        $this->markdownContent .= "请按时完成问卷  \n  ";
        $this->markdownContent .= "![]({$imgUrl})  \n  ";
        $this->markdownContent .= '开放时间：'.date('Y-m-d H:i:s', $options['startTime'])."  \n  ";
        $this->markdownContent .= '###### 发送时间：'.date('Y-m-d H:i:s', time());

        return [
            'targetType' => $this->type,
            'targetId' => $options['targetId'],
            'batch' => $options['batch'],
            'message' => $this->makeSingleContent(),
        ];
    }
}
