<?php

namespace CorporateTrainingBundle\Biz\DingTalk\Template;

use AppBundle\Common\ArrayToolkit;
use AppBundle\Common\Exception\InvalidArgumentException;

class OfflineCourseRemindTemplate extends BaseTemplate implements DingTalkTemplateInterface
{
    protected $type = 'offline_course_remind';

    protected $linkUrl = '';

    protected $markdownContent = '';

    protected $title = '线下课程上课提醒通知';

    /**
     * {@inheritdoc}
     */
    public function parse($options)
    {
        if (!ArrayToolkit::requireds($options, ['targetId', 'batch', 'url', 'imagePath', 'courseTitle', 'startTime', 'place'])) {
            throw new InvalidArgumentException('Lack of required fields');
        }
        $imgUrl = $this->getFileUrl($options['imagePath'], 'course.png');
        $this->linkUrl = isset($options['url']) ? $options['url'] : $this->getBaseUrl().'/';
        $this->markdownContent = "#### 你的线下课程参加提醒  \n  ";
        $this->markdownContent .= "![]({$imgUrl})  \n  ";
        $this->markdownContent .= "课程名称：{$options['courseTitle']}  \n  ";
        $this->markdownContent .= '上课时间：'.$options['startTime'].'至'.$options['endTime']."  \n  ";
        $this->markdownContent .= "上课地点：{$options['place']}  \n  ";
        $this->markdownContent .= '###### 发送时间：'.date('Y-m-d H:i:s', time());

        return [
            'targetType' => $this->type,
            'targetId' => $options['targetId'],
            'batch' => $options['batch'],
            'message' => $this->makeSingleContent(),
        ];
    }
}
