<?php

namespace CorporateTrainingBundle\Biz\DingTalk\Template;

use AppBundle\Common\ArrayToolkit;
use AppBundle\Common\Exception\InvalidArgumentException;
use Biz\Mail\Template\EmailTemplateInterface;

class ResourceEnrollQueueTemplate extends BaseTemplate implements EmailTemplateInterface
{
    protected $type = 'resource_enroll_queue';

    protected $linkUrl = '';

    protected $markdownContent = '';

    protected $title = '报名结果通知';

    protected $defaultImages = [
        'offlineActivity' => 'activity.png',
        'projectPlan' => 'project-plan.png',
        'offlineClass' => 'courseSet.png',
        ];

    /**
     * {@inheritdoc}
     */
    public function parse($options)
    {
        if (!ArrayToolkit::requireds($options, ['title', 'targetId', 'batch', 'url', 'imagePath', 'resourceTitle', 'type', 'queueNum', 'resourceType'])) {
            throw new InvalidArgumentException('Lack of required fields');
        }
        $content = 'review' == $options['type'] ? '你的报名通过审核' : '你的报名提交';

        $imgUrl = $this->getFileUrl($options['imagePath'], empty($defaultImages[$this->type]) ? 'courseSet.png' : $defaultImages[$this->type]);
        $this->linkUrl = isset($options['url']) ? $options['url'] : $this->getBaseUrl().'/';
        $this->markdownContent = "#### 报名结果通知  \n  ";
        $this->markdownContent .= "{$content}，进入补位中，你当前排在第{$options['queueNum']}位  \n  ";
        $this->markdownContent .= "![]({$imgUrl})  \n  ";
        $this->markdownContent .= "{$options['title']}：{$options['resourceTitle']}  \n  ";
        $this->markdownContent .= '###### 发送时间：'.date('Y-m-d H:i:s', time());

        return [
            'targetType' => $this->type,
            'targetId' => $options['targetId'],
            'batch' => $options['batch'],
            'message' => $this->makeSingleContent(),
        ];
    }
}
