<?php

namespace CorporateTrainingBundle\Biz\Enroll\Dao\Impl;

use Codeages\Biz\Framework\Dao\AdvancedDaoImpl;
use CorporateTrainingBundle\Biz\Enroll\Dao\EnrollRecordDao;

class EnrollRecordDaoImpl extends AdvancedDaoImpl implements EnrollRecordDao
{
    protected $table = 'resource_enroll_record';

    public function findByTargetIdAndUserIdAndTargetType($targetId, $userId, $targetType)
    {
        return $this->findByFields([
            'targetId' => $targetId,
            'targetType' => $targetType,
            'userId' => $userId,
        ]);
    }

    public function getByTargetIdAndUserIdAndTargetType($targetId, $userId, $targetType)
    {
        return $this->getByFields([
            'targetId' => $targetId,
            'targetType' => $targetType,
            'userId' => $userId,
        ]);
    }

    public function findByIds($ids)
    {
        return $this->findInField('id', $ids);
    }

    public function findByTargetIdAndTargetTypeAndUserIds($targetId, $targetType, $userIds)
    {
        if (empty($userIds)) {
            return [];
        }
        $marks = str_repeat('?,', count($userIds) - 1).'?';

        $sql = "SELECT * FROM {$this->table} WHERE targetId = ? AND targetType = ? AND userId IN ({$marks}) ORDER BY id DESC";

        return $this->db()->fetchAll($sql, array_merge([$targetId, $targetType], $userIds));
    }

    public function findQueueRecordsByTargetIdAndTargetType($targetId, $targetType, $count = 1)
    {
        $sql = "SELECT * FROM {$this->table} WHERE targetId = ? AND  targetType = ? AND status = ? ORDER BY queueTime,id ASC limit ".$count;

        return $this->db()->fetchAll($sql, [$targetId, $targetType, 'queue']);
    }

    public function selectRecordCountGroupByStatus($conditions)
    {
        $builder = $this->createQueryBuilder($conditions)
            ->select('count(`id`) as count, status')
            ->groupBy('status');

        return $builder->execute()->fetchAll();
    }

    public function declares()
    {
        return [
            'timestamps' => ['submittedTime', 'updatedTime', 'queueTime', 'createdTime'],
            'serializes' => [],
            'orderbys' => ['id', 'submittedTime', 'approvedTime', 'updatedTime', 'queueTime'],
            'conditions' => [
                'status = :status',
                'userId = :userId',
                'targetId = :targetId',
                'targetType = :targetType',
                'projectPlanId = :projectPlanId',
                'projectPlanId IN ( :projectPlanIds)',
                'userId IN ( :userIds)',
                'id IN ( :ids)',
                'targetId IN ( :targetIds)',
                'status NOT in ( :excludeStatus )',
                'projectPlanId IN ( :projectPlanIds)',
                'queueTime <= :queueTime_LE',
                'queueTime >= :queueTime_GE',
                'id <= :id_LE',
            ],
        ];
    }
}
