<?php

namespace CorporateTrainingBundle\Biz\Enroll\Service;

interface EnrollRecordService
{
    public function createEnrollRecord($record);

    public function updateEnrollRecord($id, $fields);

    public function getEnrollRecord($id);

    public function findEnrollRecordsByIds($ids);

    public function batchUpdateEnrollRecord($records);

    public function submitEnrollment($targetId, $userId, $targetType);

    public function findEnrollRecordsByTargetIdAndTargetTypeAndUserIds($targetId, $targetType, $userIds);

    /**
     * 获取资源排队列表
     *
     * @param $targetId
     * @param $targetType
     * @param int $count
     *
     * @return array
     */
    public function findQueueRecordsByTargetIdAndTargetType($targetId, $targetType, $count = 1);

    /**
     * 获取当前排队的位置
     *
     * @param $userId
     * @param $targetId
     * @param $targetType
     *
     * @return int
     */
    public function getUserQueueCountByTargetIdAndTargetType($userId, $targetId, $targetType);

    public function getQueueCountByTargetIdAndTargetType($targetId, $targetType);

    public function countEnrollRecords(array $conditions);

    public function searchEnrollRecords(array $conditions, array $orderBys, $start, $limit);

    public function selectEnrollRecordCountGroupByStatus($conditions);

    public function getEnrollRecordByTargetIdAndUserIdAndTargetType($targetId, $userId, $targetType);
}
