<?php

namespace CorporateTrainingBundle\Biz\Enroll\Strategy;

use Codeages\Biz\Framework\Service\Exception\NotFoundException;

class EnrollStrategyContext
{
    private $biz = null;

    public function __construct($biz)
    {
        $this->biz = $biz;
    }

    protected function getStrategyType($type)
    {
        return 'enroll_strategy_'.$type;
    }

    public function createStrategy($type)
    {
        $strategyType = $this->getStrategyType($type);
        if (isset($this->biz[$strategyType])) {
            return $this->biz[$strategyType];
        }
        throw new NotFoundException("enroll strategy {$strategyType} does not exist");
    }
}
