<?php

namespace CorporateTrainingBundle\Biz\Enroll\Strategy;

use Exception;

interface EnrollStrategyInterface
{
    /**
     * 提交报名
     *
     * @param int   $targetId
     * @param int   $userId
     * @param array $fields
     *
     * @return array
     *
     * @throws Exception
     */
    public function submitEnrollment($targetId, $userId, $fields);

    /**
     * 补位
     *
     * @param int $targetId
     * @param int $count    //补位人数
     *
     * @return bool
     *
     * @throws Exception
     */
    public function batchQueueListBecomeMember($targetId, $count);

    /**
     * 资源移除成员
     *
     * @param int   $targetId
     * @param array $userIds
     *
     * @return bool
     *
     * @throws Exception
     */
    public function deleteMembers($targetId, $userIds);

    /**
     * 取消报名
     *
     * @param int $targetId
     * @param int $userId
     *
     * @return bool
     *
     * @throws Exception
     */
    public function cancelEnroll($targetId, $userId);

    /**
     * @param int    $targetId
     * @param array  $recordIs
     * @param string $status
     * @param array  $fields
     *
     * @return bool
     */
    public function verifyEnrollment($targetId, $recordIs, $status, $fields = []);

    /**
     * @param int   $targetId
     * @param array $userIds
     *
     * @return bool
     *
     * @throws Exception
     */
    public function createEnrollRecordWithAdminAddUser($targetId, $userIds);

    /**
     * 补位直接添加成成员
     *
     * @param $targetId
     * @param $recordIs
     *
     * @return bool
     *
     * @throws Exception
     */
    public function queueListBecomeMember($targetId, $recordIs);
}
