<?php

namespace CorporateTrainingBundle\Biz\Exporter;

use AppBundle\Common\ArrayToolkit;
use CorporateTrainingBundle\Common\OrgToolkit;

class OfflineActivityMemberExporter extends BaseOfflineActivityExporter
{
    public function getExportFileName()
    {
        return 'offline_activity_member.xls';
    }

    protected function getSortedHeadingRow($parameters)
    {
        return array(
            array('code' => 'activityTitle', 'title' => $this->trans('offline_activity.activity_title')),
            array('code' => 'creator', 'title' => $this->trans('offline_activity.exporter_creator')),
            array('code' => 'startTime', 'title' => $this->trans('offline_activity.exporter_start_time')),
            array('code' => 'endTime', 'title' => $this->trans('offline_activity.exporter_end_time')),
            array('code' => 'truename', 'title' => $this->trans('student.profile.truename')),
            array('code' => 'nickname', 'title' => $this->trans('student.user_name')),
            array('code' => 'org', 'title' => $this->trans('student.profile.department')),
            array('code' => 'post', 'title' => $this->trans('student.profile.post')),
            array('code' => 'attendStatus', 'title' => $this->trans('offline_activity.attend_status')),
            array('code' => 'score', 'title' => $this->trans('offline_activity.examination.score')),
            array('code' => 'evaluate', 'title' => $this->trans('offline_activity.evaluate.set')),
            array('code' => 'passStatus', 'title' => $this->trans('offline_activity.examination.result')),
        );
    }

    protected function buildExportData($parameters)
    {
        if (empty($parameters['activityId'])) {
            throw new \InvalidArgumentException('ActivityId id not exist');
        }

        $activity = $this->getActivityService()->getOfflineActivity($parameters['activityId']);

        $creator = $this->getUserService()->getUser($activity['creator']);

        $conditions = $this->prepareSearchConditions($parameters);
        $members = $this->getMemberService()->searchMembers(
            $conditions,
            array('id' => 'asc'),
            0,
            PHP_INT_MAX
        );

        $userIds = ArrayToolkit::column($members, 'userId');

        list($users, $profiles, $orgs, $posts) = $this->buildUsersData($userIds);

        $memberData = array();

        foreach ($members as $member) {
            $memberData[] = array(
                $user = $users[$member['userId']],
                'activityTitle' => $activity['title'],
                'creator' => $creator['nickname'],
                'startTime' => empty($activity['startTime']) ? '--' : date('Y-m-d H:i', $activity['startTime']),
                'endTime' => empty($activity['endTime']) ? '--' : date('Y-m-d H:i', $activity['endTime']),
                'truename' => empty($profiles[$member['userId']]) ? '-' : $profiles[$member['userId']]['truename'],
                'nickname' => empty($users[$member['userId']]) ? '-' : $users[$member['userId']]['nickname'],
                'org' => OrgToolkit::buildOrgsNames($user['orgIds'], $orgs),
                'post' => empty($posts[$users[$member['userId']]['postId']]) ? '-' : $posts[$users[$member['userId']]['postId']]['name'],
                'attendStatus' => $this->convertAttendStatus($member['attendedStatus']),
                'score' => $member['score'],
                'evaluate' => $member['evaluate'],
                'passStatus' => ('none' === $member['passedStatus']) ? $this->trans('offline_activity.examination_status.not_examined') : (('passed' === $member['passedStatus']) ? $this->trans('offline_activity.examination_status.passed') : $this->trans('offline_activity.examination_status.unpassed')),
            );
        }

        $exportData[] = array(
            'sheetName' => $activity['title'],
            'data' => $memberData,
        );

        return $exportData;
    }

    protected function convertAttendStatus($status)
    {
        if ('attended' == $status) {
            return $this->trans('offline_activity.student.attended');
        }

        if ('unattended' == $status) {
            return $this->trans('offline_activity.student.unattended');
        }

        return $this->trans('offline_activity.attend_status.unattend');
    }
}
