<?php

namespace CorporateTrainingBundle\Biz\Exporter;

use AppBundle\Common\ArrayToolkit;

class PostListExporter extends AbstractExporter
{
    public function canExport($parameters)
    {
        $biz = $this->biz;
        $user = $biz['user'];

        return $user->hasPermission('admin_post');
    }

    public function getExportFileName()
    {
        return 'post.xls';
    }

    public function getSortedHeadingRow($parameters)
    {
        if ($this->isPluginInstalled('PostMap')) {
            return [
                ['code' => 'name', 'title' => $this->trans('admin.post.name')],
                ['code' => 'code', 'title' => $this->trans('admin.post.code')],
                ['code' => 'postGroup', 'title' => $this->trans('admin.post.group')],
                ['code' => 'rankGroup', 'title' => $this->trans('admin.post.rank_group')],
                ['code' => 'rank', 'title' => $this->trans('admin.post.rank')],
            ];
        }

        return [
            ['code' => 'name', 'title' => $this->trans('admin.post.name')],
            ['code' => 'code', 'title' => $this->trans('admin.post.code')],
            ['code' => 'postGroup', 'title' => $this->trans('admin.post.group')],
        ];
    }

    public function buildExportData($parameters)
    {
        $postGroups = $this->getPostService()->searchPostGroups([], ['seq' => 'ASC'], 0, PHP_INT_MAX);
        if ($this->isPluginInstalled('PostMap')) {
            $ranks = $this->getRankService()->getAllRanks();
            $ranks = ArrayToolkit::index($ranks, 'id');
            $rankGroupIds = ArrayToolkit::column($ranks, 'groupId');
            $rankGroups = $this->getRankService()->findRankGroupsByIds($rankGroupIds);
            $rankGroups = ArrayToolkit::index($rankGroups, 'id');
        }
        $postData = [];
        foreach ($postGroups as $postGroup) {
            $posts = $this->getPostService()->findPostsByGroupId($postGroup['id']);
            foreach ($posts as $post) {
                if ($this->isPluginInstalled('PostMap')) {
                    $postData[] = [
                        'name' => $post['name'],
                        'code' => $post['code'],
                        'postGroup' => $postGroup['name'],
                        'rankGroup' => isset($ranks[$post['rankId']]) ? $rankGroups[$ranks[$post['rankId']]['groupId']]['name'] : '--',
                        'rank' => isset($ranks[$post['rankId']]) ? $ranks[$post['rankId']]['name'] : '--',
                    ];
                } else {
                    $postData[] = [
                        'name' => $post['name'],
                        'code' => $post['code'],
                        'postGroup' => $postGroup['name'],
                    ];
                }
            }
        }

        $exportData[] = [
            'data' => $postData,
        ];

        return $exportData;
    }
}
