<?php

namespace CorporateTrainingBundle\Biz\Exporter;

use AppBundle\Common\ArrayToolkit;
use CorporateTrainingBundle\Common\OrgToolkit;
use CorporateTrainingBundle\Biz\Exporter\ResourceOfflineCourseBaseExporter as BaseOfflineCourseExporter;

class ResourceOfflineCourseAttendanceExporter extends BaseOfflineCourseExporter
{
    public function canExport($parameters)
    {
        if ($this->getOfflineCourseService()->tryManageOfflineCourse($parameters['offlineCourseId'])) {
            return true;
        }
    }

    public function getExportFileName()
    {
        return 'resource_offline_course_attendance.xls';
    }

    public function getSortedHeadingRow($parameters)
    {
        return array(
            array('code' => 'truename', 'title' => $this->trans('student.profile.truename')),
            array('code' => 'nickname', 'title' => $this->trans('student.user_name')),
            array('code' => 'org', 'title' => $this->trans('student.profile.department')),
            array('code' => 'post', 'title' => $this->trans('student.profile.post')),
            array('code' => 'status', 'title' => $this->trans('offline_activity.attend_status')),
        );
    }

    public function buildExportData($parameters)
    {
        $members = $this->getExportMembers($parameters);
        $userIds = ArrayToolkit::column($members, 'userId');
        list($users, $userProfiles, $orgs, $posts) = $this->buildUsersData($userIds);
        $status = ['none' => 'offline_course.attend_status.none', 'attended' => 'offline_course.attend_status.attended', 'partial' => 'offline_course.attend_status.partial', 'absenteeism' => 'offline_course.attend_status.absenteeism', 'leave' => 'offline_course.attend_status.leave'];
        $memberData = array();
        $offlineCourseMembers = $this->getOfflineCourseMemberService()->searchMembers(['offlineCourseId' => $parameters['offlineCourseId'], 'userIds' => $userIds], [], 0, count($userIds), ['userId', 'status']);
        $offlineCourseMembers = ArrayToolkit::index($offlineCourseMembers, 'userId');

        foreach ($members as $member) {
            $memberData[] = array(
                'truename' => empty($userProfiles[$member['userId']]) ? '-' : $userProfiles[$member['userId']]['truename'],
                'nickname' => empty($users[$member['userId']]) ? '-' : $users[$member['userId']]['nickname'],
                'org' => OrgToolkit::buildOrgsNames($users[$member['userId']]['orgIds'], $orgs),
                'post' => empty($posts[$users[$member['userId']]['postId']]) ? '-' : $posts[$users[$member['userId']]['postId']]['name'],
                'status' => empty($offlineCourseMembers[$member['userId']]) ? $this->trans($status['none']) : $this->trans($status[$offlineCourseMembers[$member['userId']]['status']]),
            );
        }

        unset($offlineCourseMembers);
        unset($users);
        unset($userProfiles);
        unset($orgs);
        unset($posts);
        $exportData[] = array(
            'data' => $memberData,
        );

        return $exportData;
    }

    protected function getExportMembers($parameters)
    {
        $conditions = $this->prepareConditions($parameters);
        $conditions = $this->prepareConditionsByAttendStatus($conditions, $parameters['offlineCourseId']);
        if ('offline_class' == $parameters['resourceType']) {
            $conditions['offlineClassId'] = $parameters['resourceId'];

            return   $this->getOfflineClassMemberService()->searchMembers($conditions, ['id' => 'DESC'], 0, PHP_INT_MAX, ['userId']);
        }
        $conditions['projectPlanId'] = $parameters['resourceId'];

        return   $this->getProjectPlanMemberService()->searchProjectPlanMembers($conditions, ['id' => 'DESC'], 0, PHP_INT_MAX, ['userId']);
    }
}
