<?php

namespace CorporateTrainingBundle\Biz\Exporter;

use AppBundle\Common\ArrayToolkit;
use OfflineCourseProPlugin\Biz\OfflineClass\Service\OfflineClassService;

class ResourceOfflineCourseBaseExporter extends AbstractExporter
{
    public function canExport($parameters)
    {
        if ($this->getOfflineCourseService()->tryManageOfflineCourse($parameters['offlineCourseId'])) {
            return true;
        }
    }

    protected function buildExportData($parameters)
    {
        // TODO: Implement buildExportData() method.
    }

    protected function prepareConditions($conditions)
    {
        if (isset($conditions['orgIds'])) {
            $conditions['orgIds'] = explode(',', $conditions['orgIds']);
            $users = $this->getUserOrgService()->searchUserOrgs(
                array('orgIds' => $conditions['orgIds']),
                array(),
                0,
                PHP_INT_MAX,
                ['userId']
            );
            $conditions['userIds'] = ArrayToolkit::column($users, 'userId');
        }

        if (!empty($conditions['username'])) {
            $userIds = $this->getUserService()->findUserIdsByNickNameOrTrueName($conditions['username']);
            $conditions['userIds'] = (empty($conditions['userIds']) || empty($userIds)) ? array() : array_intersect($conditions['userIds'], $userIds);
            unset($conditions['username']);
        }

        if (!empty($conditions['username'])) {
            $userIds = $this->getUserService()->findUserIdsByNickNameOrTrueName($conditions['username']);
            $conditions['userIds'] = (empty($conditions['userIds']) || empty($userIds)) ? array() : array_intersect($conditions['userIds'], $userIds);
            unset($conditions['username']);
        }

        if (isset($conditions['userIds'])) {
            $conditions['userIds'] = empty($conditions['userIds']) ? array(-1) : $conditions['userIds'];
        }

        return $conditions;
    }

    protected function prepareConditionsByAttendStatus($conditions, $offlineCourseId)
    {
        if (!empty($conditions['attendStatus']) && !in_array($conditions['attendStatus'], ['none', 'all'])) {
            $members = $this->getOfflineCourseMemberService()->searchMembers(['status' => $conditions['attendStatus'], 'userIds' => $conditions['userIds'], 'offlineCourseId' => $offlineCourseId], [], 0, count($conditions['userIds']), ['userId']);
            $userIds = ArrayToolkit::column($members, 'userId');
            $conditions['userIds'] = (empty($conditions['userIds']) || empty($userIds)) ? [] : array_intersect($conditions['userIds'], $userIds);
        }

        if (!empty($conditions['attendStatus']) && 'none' == $conditions['attendStatus']) {
            $members = $this->getOfflineCourseMemberService()->searchMembers(['excludeStatus' => $conditions['attendStatus'], 'userIds' => $conditions['userIds'], 'offlineCourseId' => $offlineCourseId], [], 0, count($conditions['userIds']), ['userId']);
            $userIds = ArrayToolkit::column($members, 'userId');
            $conditions['userIds'] = empty($conditions['userIds']) ? [] : array_diff($conditions['userIds'], $userIds);
        }

        unset($conditions['attendStatus']);
        if (isset($conditions['userIds'])) {
            $conditions['userIds'] = empty($conditions['userIds']) ? [-1] : $conditions['userIds'];
        }

        return $conditions;
    }

    protected function prepareConditionsByHomeworkStatus($conditions, $taskId)
    {
        if (!empty($conditions['homeworkStatus']) && !in_array($conditions['homeworkStatus'], ['none', 'all'])) {
            $results = $this->getOfflineCourseTaskResultService()->searchTaskResults(['status' => $conditions['homeworkStatus'], 'userIds' => $conditions['userIds'], 'taskId' => $taskId], [], 0, count($conditions['userIds']), ['userId']);
            $userIds = ArrayToolkit::column($results, 'userId');
            $conditions['userIds'] = (empty($conditions['userIds']) || empty($userIds)) ? array() : array_intersect($conditions['userIds'], $userIds);
        }

        if (!empty($conditions['homeworkStatus']) && 'none' == $conditions['homeworkStatus']) {
            $results = $this->getOfflineCourseTaskResultService()->searchTaskResults(['taskId' => $taskId], [], 0, PHP_INT_MAX, ['userId']);
            $userIds = ArrayToolkit::column($results, 'userId');
            $conditions['userIds'] = empty($conditions['userIds']) ? array() : array_diff($conditions['userIds'], $userIds);
        }

        unset($conditions['homeworkStatus']);
        if (isset($conditions['userIds'])) {
            $conditions['userIds'] = empty($conditions['userIds']) ? array(-1) : $conditions['userIds'];
        }

        return $conditions;
    }

    protected function prepareOrgIds($conditions)
    {
        if (isset($conditions['orgIds']) && empty($conditions['orgIds'])) {
            $conditions['orgIds'] = array(-1);

            return $conditions;
        }

        return explode(',', $conditions['orgIds']);
    }

    /**
     * @return \CorporateTrainingBundle\Biz\ProjectPlan\Service\Impl\MemberServiceImpl
     */
    protected function getProjectPlanMemberService()
    {
        return $this->createService('CorporateTrainingBundle:ProjectPlan:MemberService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\TaskServiceImpl
     */
    protected function getOfflineCourseTaskService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:TaskService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\OfflineCourseServiceImpl
     */
    protected function getOfflineCourseService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:OfflineCourseService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\MemberServiceImpl
     */
    protected function getOfflineCourseMemberService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:MemberService');
    }

    /**
     * @return OfflineClassService
     */
    protected function getOfflineClassService()
    {
        return $this->createService('OfflineCourseProPlugin:OfflineClass:OfflineClassService');
    }

    /**
     * @return \OfflineCourseProPlugin\Biz\OfflineClass\Service\MemberService
     */
    protected function getOfflineClassMemberService()
    {
        return $this->createService('OfflineCourseProPlugin:OfflineClass:MemberService');
    }

    public function getExportFileName()
    {
        // TODO: Implement getExportFileName() method.
    }

    protected function getSortedHeadingRow($parameters)
    {
        // TODO: Implement getSortedHeadingRow() method.
    }
}
