<?php

namespace CorporateTrainingBundle\Biz\Exporter;

use AppBundle\Common\ArrayToolkit;
use CorporateTrainingBundle\Common\OrgToolkit;
use CorporateTrainingBundle\Biz\Exporter\ResourceOfflineCourseBaseExporter as BaseOfflineCourseExporter;

class ResourceOfflineCourseHomeworkRecordExporter extends BaseOfflineCourseExporter
{
    public function canExport($parameters)
    {
        if ($this->getOfflineCourseService()->tryManageOfflineCourse($parameters['offlineCourseId'])) {
            return true;
        }
    }

    public function getExportFileName()
    {
        return 'project_plan_offline_course_homework_record.xls';
    }

    public function getSortedHeadingRow($parameters)
    {
        return array(
            array('code' => 'truename', 'title' => $this->trans('student.profile.truename')),
            array('code' => 'nickname', 'title' => $this->trans('student.user_name')),
            array('code' => 'org', 'title' => $this->trans('student.profile.department')),
            array('code' => 'post', 'title' => $this->trans('student.profile.post')),
            array('code' => 'homeworkStatus', 'title' => $this->trans('offline_course.homework_status')),
        );
    }

    public function buildExportData($parameters)
    {
        $members = $this->getExportMembers($parameters);
        $userIds = empty($members) ? array(-1) : ArrayToolkit::column($members, 'userId');
        list($users, $userProfiles, $orgs, $posts) = $this->buildUsersData($userIds);
        $taskResults = $this->getOfflineCourseTaskResultService()->searchTaskResults(['taskId' => $parameters['taskId'], 'userIds' => $userIds], [], 0, count($userIds));
        $taskResults = ArrayToolkit::index($taskResults, 'userId');
        $status = ['none' => 'project_plan.status.not_submitted', 'unpassed' => 'project_plan.status.unpass', 'finished' => 'project_plan.status.passed', 'submitted' => 'project_plan.status.not_review'];

        $memberData = array();
        foreach ($members as $member) {
            $memberData[] = array(
                $user = $users[$member['userId']],
                'truename' => empty($userProfiles[$member['userId']]) ? '-' : $userProfiles[$member['userId']]['truename'],
                'nickname' => empty($users[$member['userId']]) ? '-' : $users[$member['userId']]['nickname'],
                'org' => OrgToolkit::buildOrgsNames($user['orgIds'], $orgs),
                'post' => empty($posts[$users[$member['userId']]['postId']]) ? '-' : $posts[$users[$member['userId']]['postId']]['name'],
                'homeworkStatus' => empty($taskResults[$member['userId']]) ? $this->trans($status['none']) : $this->trans($status[$taskResults[$member['userId']]['status']]),
            );
        }
        unset($members);
        unset($users);
        unset($userProfiles);
        unset($orgs);
        $exportData[] = array(
            'data' => $memberData,
        );

        return $exportData;
    }

    protected function getExportMembers($parameters)
    {
        $conditions = $this->prepareConditions($parameters);
        $conditions = $this->prepareConditionsByHomeworkStatus($conditions, $parameters['taskId']);
        if ('offline_class' == $parameters['resourceType']) {
            $conditions['offlineClassId'] = $parameters['resourceId'];

            return   $this->getOfflineClassMemberService()->searchMembers($conditions, ['id' => 'DESC'], 0, PHP_INT_MAX, ['userId']);
        }
        $conditions['projectPlanId'] = $parameters['resourceId'];

        return   $this->getProjectPlanMemberService()->searchProjectPlanMembers($conditions, ['id' => 'DESC'], 0, PHP_INT_MAX, ['userId']);
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\TaskServiceImpl
     */
    protected function getOfflineCourseTaskResultService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:TaskService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\ProjectPlan\Service\Impl\MemberServiceImpl
     */
    protected function getProjectPlanMemberService()
    {
        return $this->createService('CorporateTrainingBundle:ProjectPlan:MemberService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\TaskServiceImpl
     */
    protected function getOfflineCourseTaskService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:TaskService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\OfflineCourse\Service\Impl\OfflineCourseServiceImpl
     */
    protected function getOfflineCourseService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineCourse:OfflineCourseService');
    }
}
