<?php

namespace CorporateTrainingBundle\Biz\Focus\Service\Impl;

use Biz\BaseService;
use CorporateTrainingBundle\Biz\Focus\Service\FocusService;

class FocusServiceImpl extends BaseService implements FocusService
{
    public function findFocusToday($time)
    {
        $strategyTypes = $this->getStrategyTypes();
        $focusItems = [];
        foreach ($strategyTypes as $strategyType) {
            $focusStrategy = $this->getFocusService($strategyType);

            if (empty($focusStrategy)) {
                continue;
            }

            $focuses = $focusStrategy->findFocusToday($time);

            if (!empty($focuses)) {
                foreach ($focuses as &$focus) {
                    $focus['type'] = $strategyType;
                    array_push($focusItems, $focus);
                }
            }
        }

        return $this->array_sort($focusItems, 'startTime');
    }

    protected function array_sort($array, $on, $order = SORT_ASC)
    {
        $new_array = [];
        $sortable_array = [];

        if (count($array) > 0) {
            foreach ($array as $k => $v) {
                if (is_array($v)) {
                    foreach ($v as $k2 => $v2) {
                        if ($k2 == $on) {
                            $sortable_array[$k] = $v2;
                        }
                    }
                } else {
                    $sortable_array[$k] = $v;
                }
            }

            if (SORT_ASC == $order) {
                asort($sortable_array);
            } else {
                arsort($sortable_array);
            }

            foreach ($sortable_array as $k => $v) {
                $new_array[$k] = $array[$k];
            }
        }

        return $new_array;
    }

    protected function getStrategyTypes()
    {
        $strategyTypes = [
            'live_course',
            'offline_exam',
            'offline_activity',
        ];

        if ($this->biz['pluginConfigurationManager']->isPluginInstalled('Exam')) {
            array_push($strategyTypes, 'exam');
        }

        if ($this->biz['pluginConfigurationManager']->isPluginInstalled('Survey')) {
            array_push($strategyTypes, 'survey');
        }

        if ($this->biz['pluginConfigurationManager']->isPluginInstalled('OfflineCoursePro')) {
            array_push($strategyTypes, 'offline_course');
        }

        return $strategyTypes;
    }

    protected function getFocusService($type)
    {
        $focus = $this->biz->offsetGet('focus_'.$type);
        if (!empty($focus)) {
            return $focus;
        }

        return null;
    }
}
