<?php

namespace CorporateTrainingBundle\Biz\Focus\Strategy\Impl;

use AppBundle\Common\ArrayToolkit;
use CorporateTrainingBundle\Biz\Course\Service\CourseService;
use CorporateTrainingBundle\Biz\Course\Service\MemberService;
use CorporateTrainingBundle\Biz\Focus\Strategy\BaseFocusStrategy;
use CorporateTrainingBundle\Biz\Focus\Strategy\FocusStrategy;

class LiveCourseFocusStrategyImpl extends BaseFocusStrategy implements FocusStrategy
{
    /**
     * 只取当天的数据
     *
     * @param $time
     *
     * @return array
     */
    public function findFocusToday($time)
    {
        $myTeachingCourseIds = $this->findMyTeachingLiveCourseIds();

        if (empty($myTeachingCourseIds)) {
            return [];
        }
        $todayStart = strtotime(date('Y-m-d', $time));
        $todayEnd = $todayStart + 24 * 3600;

        $currentUser = $this->getCurrentUser();
        if (!$currentUser->hasPermission('admin_train_teach_manage_my_teaching_my_works_manage')) {
            return [];
        }

        $conditions = [
            'courseIds' => $myTeachingCourseIds,
            'startTime_GE' => $todayStart,
            'startTime_LE' => $todayEnd,
            'status' => 'published',
            'type' => 'live',
        ];

        // 查出所有开始时间落在当天的数据
        return $this->getCourseTaskService()->searchTasks(
            $conditions,
            ['startTime' => 'DESC'],
            0,
            $this->getCourseTaskService()->countTasks($conditions)
        );
    }

    protected function findMyTeachingLiveCourseIds()
    {
        $currentUser = $this->getCurrentUser();
        $members = $this->getMemberService()->findTeacherMembersByUserId($currentUser['id']);

        if (empty($members)) {
            return [];
        }

        return ArrayToolkit::column($members, 'courseId');
    }

    /**
     * @return CourseService
     */
    protected function getCourseService()
    {
        return $this->createService('CorporateTrainingBundle:Course:CourseService');
    }

    protected function getCourseTaskService()
    {
        return $this->createService('Task:TaskService');
    }

    /**
     * @return MemberService
     */
    protected function getMemberService()
    {
        return $this->createService('CorporateTrainingBundle:Course:MemberService');
    }
}
