<?php

namespace CorporateTrainingBundle\Biz\Focus\Strategy\Impl;

use CorporateTrainingBundle\Biz\Focus\Strategy\BaseFocusStrategy;
use CorporateTrainingBundle\Biz\Focus\Strategy\FocusStrategy;
use CorporateTrainingBundle\Biz\OfflineActivity\Service\OfflineActivityService;

class OfflineActivityFocusStrategyImpl extends BaseFocusStrategy implements FocusStrategy
{
    /**
     * 只取当天的数据
     *
     * @param $time
     *
     * @return array
     */
    public function findFocusToday($time)
    {
        $todayStart = strtotime(date('Y-m-d', $time));
        $todayEnd = $todayStart + 24 * 3600;

        $currentUser = $this->getCurrentUser();
        if (!$currentUser->hasPermission('admin_train_teach_manage_my_teaching_my_works_manage')) {
            return [];
        }

        $conditions = [
            'startTime_GE' => $todayStart,
            'startTime_LE' => $todayEnd,
            'creator' => $currentUser['id'],
            'status' => 'published',
        ];

        // 查出所有开始时间落在当天的数据
        return $this->getOfflineActivityService()->searchOfflineActivities(
            $conditions,
            ['startTime' => 'DESC'],
            0,
            $this->getOfflineActivityService()->countOfflineActivities($conditions)
        );
    }

    /**
     * @return OfflineActivityService
     */
    protected function getOfflineActivityService()
    {
        return $this->createService('CorporateTrainingBundle:OfflineActivity:OfflineActivityService');
    }
}
