<?php

namespace CorporateTrainingBundle\Biz\Importer;

use AppBundle\Common\ArrayToolkit;
use CorporateTrainingBundle\Biz\ProjectPlan\Service\MemberService;
use CorporateTrainingBundle\Biz\ProjectPlan\Service\ProjectPlanService;
use Symfony\Component\HttpFoundation\Request;

class ProjectPlanOfflineExamResultImporter extends OfflineExamResultImporter
{
    protected $type = 'project-plan-offline-exam-result';

    protected $idName = 'projectPlanId';

    public function tryImport(Request $request)
    {
        $this->getProjectPlanService()->hasManageProjectPlanPermission();
    }

    public function getTemplate(Request $request)
    {
        $projectPlanId = $request->query->get('id');
        $offlineExamId = $request->query->get('offlineExamId');

        return $this->render('project-plan/exam-manage/offline-exam/exam-result-import.html.twig', [
            'projectPlanId' => $projectPlanId,
            'offlineExamId' => $offlineExamId,
            'importerType' => $this->type,
        ]);
    }

    protected function buildCustomParams($params)
    {
        return [
            'projectPlanId' => $params['projectPlanId'],
            'offlineExamId' => $params['offlineExamId'],
        ];
    }

    protected function log($data)
    {
        if (!ArrayToolkit::requireds($data, ['id', 'user', 'offlineExam'])) {
            return;
        }

        $projectPlan = $this->getProjectPlanService()->getProjectPlan($data['id']);
        $user = $data['user'];
        $offlineExam = $data['offlineExam'];

        $this->getLogService()->info('offline_exam', 'add_result', "培训项目《{$projectPlan['name']}》(#{$projectPlan['id']})，添加学员{$user['nickname']}(#{$user['id']})的线下考试{$offlineExam['title']}(#{$offlineExam['id']})成绩，备注：通过批量导入添加");
    }

    protected function getMember($user, $offlineExam)
    {
        return $this->getProjectPlanMemberService()->getProjectPlanMemberByUserIdAndProjectPlanId($user['id'], $offlineExam['targetId']);
    }

    /**
     * @return ProjectPlanService
     */
    protected function getProjectPlanService()
    {
        return $this->getServiceKernel()->getBiz()->service('CorporateTrainingBundle:ProjectPlan:ProjectPlanService');
    }

    /**
     * @return MemberService
     */
    protected function getProjectPlanMemberService()
    {
        return $this->getServiceKernel()->getBiz()->service('CorporateTrainingBundle:ProjectPlan:MemberService');
    }
}
