<?php

namespace CorporateTrainingBundle\Biz\NotificationCenter\Event;

use Codeages\Biz\Framework\Event\Event;
use Codeages\PluginBundle\Event\EventSubscriber;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ResourceNotificationEventSubscriber extends EventSubscriber implements EventSubscriberInterface
{
    public static function getSubscribedEvents()
    {
        return [
            'batch.create.post_courses' => ['onBatchCreatePostCourses', 100],
            'become_project_plan_member' => 'onBecomeProjectPlanMember',
            'project_plan.create.offline_exam' => 'onOfflineExamCreate',
            'project_plan.update.offline_exam' => 'onOfflineExamCreate',
            'project_plan.delete.offline_exam' => 'onOfflineExamDelete',
            'offline_class.create.offline_exam' => 'onOfflineExamCreate',
            'offline_class.update.offline_exam' => 'onOfflineExamCreate',
            'offline_class.delete.offline_exam' => 'onOfflineExamDelete',
            'offline.exam.mark.pass' => 'onOfflineExamMarkPass',
            'offline.exam.mark.unpass' => 'onOfflineExamMarkUnPass',
            'offline_course.create' => 'onOfflineCourseCreate',
            'offline_course.update' => 'onOfflineCourseUpdate',
            'offline_course.delete' => 'onOfflineCourseDelete',
            'offline_course.close' => 'onOfflineCourseDelete',
            'project_plan.create.questionnaire' => ['onResourceQuestionnaireCreate', 100],
            'offline_class.create.questionnaire' => ['onResourceQuestionnaireCreate', 100],
            'project_plan.update.questionnaire' => ['onResourceQuestionnaireUpdate', 100],
            'offline_class.update.questionnaire' => ['onResourceQuestionnaireUpdate', 100],
            'project_plan.delete.questionnaire' => ['onResourceQuestionnaireDelete', 100],
            'offline_class.delete.questionnaire' => ['onResourceQuestionnaireDelete', 100],
            'projectPlan.item.set' => 'onProjectPlanItemSet',
        ];
    }

    /**
     * 岗位添加课程
     *
     * @param Event $event
     */
    public function onBatchCreatePostCourses(Event $event)
    {
        $content = $event->getSubject();
        $postId = $content['postId'];
        $courses = $content['courses'];
        $resource = $this->getBiz()->offsetGet('resource_notification.post_course');
        $resource->onBatchCreatePostCourses($postId, $courses);
    }

    /**
     * 培训项目推送成员
     *
     * @param Event $event
     */
    public function onBecomeProjectPlanMember(Event $event)
    {
        $member = $event->getSubject();

        $resource = $this->getBiz()->offsetGet('resource_notification.project_plan');
        $resource->onBecomeProjectPlanMember($member);
    }

    /**
     * 创建线下课程
     *
     * @param Event $event
     */
    public function onOfflineCourseCreate(Event $event)
    {
        $offlineCourse = $event->getSubject();
        $resource = $this->getBiz()->offsetGet('resource_notification.offline_course');
        $resource->onOfflineCourseCreate($offlineCourse);
    }

    /**
     * 更新线下课程
     *
     * @param Event $event
     *
     * @return bool
     */
    public function onOfflineCourseUpdate(Event $event)
    {
        $offlineCourse = $event->getSubject();
        $oldCourse = $event->getArgument('oldOfflineCourse');
        if ($offlineCourse['startTime'] == $oldCourse['startTime']) {
            return true;
        }
        $resource = $this->getBiz()->offsetGet('resource_notification.offline_course');
        $resource->onOfflineCourseUpdate($offlineCourse);
    }

    /**
     * 删除线下课程
     *
     * @param Event $event
     */
    public function onOfflineCourseDelete(Event $event)
    {
        $offlineCourse = $event->getSubject();
        $resource = $this->getBiz()->offsetGet('resource_notification.offline_course');
        $resource->onOfflineCourseDelete($offlineCourse);
    }

    /**
     * 开班，培训项目 推送评价
     *
     * @param Event $event
     */
    public function onResourceQuestionnaireCreate(Event $event)
    {
        $item = $event->getSubject();
        $type = $event->getArgument('type');
        $resource = $this->getBiz()->offsetGet('resource_notification.resource_questionnaire');
        $resource->onResourceQuestionnaireCreate($item, $type);
    }

    /**
     * 开班，培训项目 推送评价
     *
     * @param Event $event
     */
    public function onResourceQuestionnaireUpdate(Event $event)
    {
        $item = $event->getSubject();
        $type = $event->getArgument('type');
        $resource = $this->getBiz()->offsetGet('resource_notification.resource_questionnaire');
        $resource->onResourceQuestionnaireUpdate($item, $type);
    }

    /**
     * 开班，培训项目 推送评价
     *
     * @param Event $event
     */
    public function onResourceQuestionnaireDelete(Event $event)
    {
        $item = $event->getSubject();
        $type = $event->getArgument('type');
        $resource = $this->getBiz()->offsetGet('resource_notification.resource_questionnaire');
        $resource->onResourceQuestionnaireDelete($item, $type);
    }

    /**
     * 线下考试提醒
     *
     * @param Event $event
     */
    public function onOfflineExamCreate(Event $event)
    {
        $exam = $event->getSubject();

        $resource = $this->getBiz()->offsetGet('resource_notification.offline_exam');
        $resource->onOfflineExamCreate($exam);
    }

    /**
     * 线下考试提醒
     *
     * @param Event $event
     */
    public function onOfflineExamDelete(Event $event)
    {
        $exam = $event->getSubject();

        $resource = $this->getBiz()->offsetGet('resource_notification.offline_exam');
        $resource->onOfflineExamDelete($exam);
    }

    /**
     * 线下考试结果提醒
     *
     * @param Event $event
     */
    public function onOfflineExamMarkPass(Event $event)
    {
        $member = $event->getSubject();

        $resource = $this->getBiz()->offsetGet('resource_notification.offline_exam');
        $resource->onOfflineExamMarkPass($member);
    }

    /**
     * 线下考试结果提醒
     *
     * @param Event $event
     */
    public function onOfflineExamMarkUnPass(Event $event)
    {
        $member = $event->getSubject();

        $resource = $this->getBiz()->offsetGet('resource_notification.offline_exam');
        $resource->onOfflineExamMarkUnPass($member);
    }

    /**
     * 培训内容更新
     *
     * @param Event $event
     */
    public function onProjectPlanItemSet(Event $event)
    {
        $projectPlanId = $event->getSubject();

        $resource = $this->getBiz()->offsetGet('resource_notification.project_plan');
        $resource->onProjectPlanItemSet($projectPlanId);
    }
}
