<?php

namespace CorporateTrainingBundle\Biz\NotificationCenter\Job;

use AppBundle\Common\ArrayToolkit;
use Biz\System\Service\SettingService;
use Codeages\Biz\Framework\Scheduler\AbstractJob;
use CorporateTrainingBundle\Biz\ProjectPlan\Service\ProjectPlanService;
use OfflineCourseProPlugin\Biz\OfflineClass\Service\OfflineClassService;

class ExamRemindMailNotificationJob extends AbstractJob
{
    public function execute()
    {
        $mailSetting = $this->getSettingService()->get('mail_notification', []);
        if (empty($mailSetting['project_plan_progress'])) {
            return;
        }

        if (!ArrayToolkit::requireds($this->args, ['exam'])) {
            throw new \InvalidArgumentException('Lack of required fields');
        }
        $exam = $this->args['exam'];
        if (empty($exam) || !in_array($exam['targetType'], ['projectPlan', 'offlineClass'])) {
            return;
        }
        if ('offlineClass' == $exam['targetType']) {
            $resource = $this->getOfflineClassService()->getClass($exam['targetId']);
            $resourceName = $resource['title'];
            $type = 'offline_class';
        } elseif ('projectPlan' == $exam['targetType']) {
            $resource = $this->getProjectPlanService()->getProjectPlan($exam['targetId']);
            $type = 'project_plan';
            $resourceName = $resource['name'];
        }

        if (empty($resource) || 'published' != $resource['status']) {
            return;
        }
        $idName = $exam['targetType'].'Id';

        $to = [
            'type' => $type,
            "{$idName}" => $exam['targetId'],
            'startNum' => 0,
            'perPageNum' => 20,
        ];

        $content = [
            'template' => 'exam_start_remind',
            'params' => [
                'resourceName' => $resourceName,
                'examName' => $exam['name'],
                'startTime' => date('Y-m-d H:i:s', $exam['startTime']),
                'url' => $this->generateUrl('exam_show', ['id' => $exam['id']], true),
            ],
        ];

        $this->biz->offsetGet('notification_email')->send($to, $content);
    }

    protected function generateUrl($name, $parameters, $referenceType)
    {
        global $kernel;

        return $kernel->getContainer()->get('router')->generate($name, $parameters, $referenceType);
    }

    /**
     * @return SettingService
     */
    protected function getSettingService()
    {
        return $this->biz->service('System:SettingService');
    }

    /**
     * @return ProjectPlanService
     */
    protected function getProjectPlanService()
    {
        return $this->biz->service('CorporateTrainingBundle:ProjectPlan:ProjectPlanService');
    }

    /**
     * @return OfflineClassService
     */
    protected function getOfflineClassService()
    {
        return $this->biz->service('OfflineCourseProPlugin:OfflineClass:OfflineClassService');
    }
}
