<?php

namespace CorporateTrainingBundle\Biz\NotificationCenter\Job;

use AppBundle\Common\ArrayToolkit;
use Biz\System\Service\SettingService;
use Codeages\Biz\Framework\Scheduler\AbstractJob;
use CorporateTrainingBundle\Biz\ProjectPlan\Service\ProjectPlanService;
use OfflineCourseProPlugin\Biz\OfflineClass\Service\OfflineClassService;

class OfflineCourseRemindNotificationJob extends AbstractJob
{
    public function execute()
    {
        if (!ArrayToolkit::requireds($this->args, ['offlineCourse'])) {
            throw new \InvalidArgumentException('Lack of required fields');
        }
        $offlineCourse = $this->args['offlineCourse'];
        if (empty($offlineCourse) || !in_array($offlineCourse['targetType'], ['offlineClass', 'projectPlan'])) {
            return;
        }
        if ('offlineClass' == $offlineCourse['targetType']) {
            $resource = $this->getOfflineClassService()->getClass($offlineCourse['targetId']);
        } elseif ('projectPlan' == $offlineCourse['targetType']) {
            $resource = $this->getProjectPlanService()->getProjectPlan($offlineCourse['targetId']);
        }

        if (empty($resource) || 'published' != $resource['status']) {
            return true;
        }
        $this->sendSmsNotification($offlineCourse);
        $this->sendDingTalkAndMailNotification($offlineCourse, $resource);
    }

    protected function sendSmsNotification($offlineCourse)
    {
        if (!$this->getSmsService()->isOpen('sms_offline_course_start')) {
            return true;
        }
        if ('offlineClass' == $offlineCourse['targetType']) {
            $type = 'offline_class';
        } elseif ('projectPlan' == $offlineCourse['targetType']) {
            $type = 'project_plan';
        }
        $to = [
            'type' => $type,
            'projectPlanId' => $offlineCourse['targetId'],
            'offlineClassId' => $offlineCourse['targetId'],
            'startNum' => 0,
            'perPageNum' => 20,
        ];
        $content = [
            'template' => 'offline_course_start',
            'params' => [
                'title' => $offlineCourse['title'],
                'place' => $offlineCourse['place'],
                'startTime' => date('Y-m-d H:i:s', $offlineCourse['startTime']),
            ],
        ];
        $this->biz->offsetGet('notification_sms')->send($to, $content);
    }

    protected function sendDingTalkAndMailNotification($offlineCourse, $resource)
    {
        $mailSetting = $this->getSettingService()->get('mail_notification', []);
        $dingtalkSetting = $this->getSettingService()->get('dingtalk_notification', []);
        if (!empty($mailSetting['project_plan_progress'])) {
            $types[] = 'email';
        }
        if (!empty($dingtalkSetting['offline_course_remind'])) {
            $types[] = 'dingtalk';
        }

        if (empty($types)) {
            return true;
        }
        global $kernel;
        if ('offlineClass' == $offlineCourse['targetType']) {
            $offlineCourseTemplate = $this->getOfflineCourseTemplateService()->getTemplate($resource['templateId']);
            $resource['cover'] = empty($offlineCourseTemplate['cover']) ? [] : $offlineCourseTemplate['cover'];
            $type = 'offline_class';
            $url = $kernel->getContainer()->get('router')->generate('offline_course_show', ['id' => $offlineCourse['templateId']], true);
        } elseif ('projectPlan' == $offlineCourse['targetType']) {
            $type = 'project_plan';
            $url = $kernel->getContainer()->get('router')->generate('project_plan_detail', ['id' => $offlineCourse['targetId']], true);
        }
        if (false !== strpos($url, '//localhost') || false !== strpos($url, '//127.0.0.1')) {
            $siteSetting = $this->getSettingService()->get('site');
            $url = $siteSetting['url'].substr($url, strpos($url, '/', strpos($url, '//') + 2));
        }

        $to = [
            'type' => $type,
            'projectPlanId' => $offlineCourse['targetId'],
            'offlineClassId' => $offlineCourse['targetId'],
            'startNum' => 0,
            'perPageNum' => 20,
        ];

        $content = [
            'template' => 'offline_course_remind',
            'params' => [
                'targetType' => $offlineCourse['targetType'],
                'targetId' => $offlineCourse['id'],
                'batch' => 'offline_course_remind'.$offlineCourse['id'].time(),
                'url' => $url,
                'courseTitle' => $offlineCourse['title'],
                'place' => $offlineCourse['place'],
                'startTime' => date('Y-m-d H:i:s', $offlineCourse['startTime']),
                'endTime' => date('Y-m-d H:i:s', $offlineCourse['endTime']),
                'imagePath' => empty($resource['cover']['large']) ? '' : $resource['cover']['large'],
            ],
        ];

        $this->biz->offsetGet('notification_default')->send($types, $to, $content);
    }

    /**
     * @return SettingService
     */
    protected function getSettingService()
    {
        return $this->biz->service('System:SettingService');
    }

    /**
     * @return ProjectPlanService
     */
    protected function getProjectPlanService()
    {
        return $this->biz->service('CorporateTrainingBundle:ProjectPlan:ProjectPlanService');
    }

    /**
     * @return OfflineClassService
     */
    protected function getOfflineClassService()
    {
        return $this->biz->service('OfflineCourseProPlugin:OfflineClass:OfflineClassService');
    }

    protected function getSmsService()
    {
        return $this->biz->service('Sms:SmsService');
    }
}
