<?php

namespace CorporateTrainingBundle\Biz\NotificationCenter\Job;

use AppBundle\Common\ArrayToolkit;
use Biz\Sms\Service\SmsService;
use CorporateTrainingBundle\Biz\DingTalk\Job\AbstractDingTalkNotificationJob;
use CorporateTrainingBundle\Biz\ProjectPlan\Service\ProjectPlanService;
use OfflineCourseProPlugin\Biz\OfflineClass\Service\OfflineClassService;

class OfflineExamDingTalkNotificationJob extends AbstractDingTalkNotificationJob
{
    public function execute()
    {
        if (!ArrayToolkit::requireds($this->args, ['notificationType', 'template'])) {
            throw new \InvalidArgumentException('Lack of required fields');
        }

        if ('offline_exam_day_remind' == $this->args['notificationType']) {
            $this->sendOneDaySms();
        }

        $dingtalkNotification = $this->getSettingService()->get('dingtalk_notification', []);
        if (empty($dingtalkNotification[$this->args['notificationType']])) {
            return true;
        }

        if ($this->canSend()) {
            list($to, $content) = $this->buildNotificationData();
            $this->biz->offsetGet('notification_default')->send(['dingtalk'], $to, $content);
        }

        return true;
    }

    protected function canSend()
    {
        if (empty($this->args['exam'])) {
            throw new \InvalidArgumentException('Lack of required fields');
        }

        $exam = $this->args['exam'];

        if ('projectPlan' == $exam['targetType']) {
            $projectPlan = $this->getProjectPlanService()->getProjectPlan($exam['targetId']);

            return 'published' == $projectPlan['status'];
        }
        if ('offlineClass' == $exam['targetType']) {
            $offlineClass = $this->getOfflineClassService()->getClass($exam['targetId']);

            return 'published' == $offlineClass['status'];
        }

        return false;
    }

    protected function buildNotificationData()
    {
        $exam = $this->args['exam'];
        $idName = $exam['targetType'].'Id';
        $to = [
            'type' => 'offlineClass' == $exam['targetType'] ? 'offline_class' : 'project_plan',
            "{$idName}" => $exam['targetId'],
            'startNum' => 0,
            'perPageNum' => 20,
        ];
        $content = [
            'template' => $this->args['template'],
            'params' => [
                'targetId' => $exam['id'],
                'batch' => 'offline_exam_remind'.$exam['id'].time(),
                'url' => $this->args['url'],
                'title' => $exam['title'],
                'place' => $exam['place'],
                'startTime' => $exam['startTime'],
                'endTime' => $exam['endTime'],
            ],
        ];

        return [$to, $content];
    }

    protected function sendOneDaySms()
    {
        if (!$this->getSmsService()->isOpen('sms_offline_exam_start')) {
            return true;
        }
        $exam = $this->args['exam'];
        $idName = $exam['targetType'].'Id';
        $to = [
            'type' => 'offlineClass' == $exam['targetType'] ? 'offline_class' : 'project_plan',
            "{$idName}" => $exam['targetId'],
            'startNum' => 0,
            'perPageNum' => 20,
        ];
        $content = [
            'template' => 'offline_exam_start',
            'params' => [
                'title' => $exam['title'],
                'place' => $exam['place'],
                'startTime' => date('Y-m-d H:i:s', $exam['startTime']),
            ],
        ];
        $this->biz->offsetGet('notification_sms')->send($to, $content);
    }

    /**
     * @return ProjectPlanService
     */
    protected function getProjectPlanService()
    {
        return $this->biz->service('CorporateTrainingBundle:ProjectPlan:ProjectPlanService');
    }

    /**
     * @return OfflineClassService
     */
    protected function getOfflineClassService()
    {
        return $this->biz->service('OfflineCourseProPlugin:OfflineClass:OfflineClassService');
    }

    /**
     * @return SmsService
     */
    protected function getSmsService()
    {
        return $this->biz->service('Sms:SmsService');
    }
}
