<?php

namespace CorporateTrainingBundle\Biz\NotificationCenter\Job;

use AppBundle\Common\ArrayToolkit;
use AppBundle\Common\SettingToolkit;
use Biz\System\Service\SettingService;
use Codeages\Biz\Framework\Scheduler\AbstractJob;
use CorporateTrainingBundle\Biz\ProjectPlan\Service\ProjectPlanService;
use OfflineCourseProPlugin\Biz\OfflineClass\Service\OfflineClassService;

class ResourceSurveyRemindNotificationJob extends AbstractJob
{
    public function execute()
    {
        if (!ArrayToolkit::requireds($this->args, ['item', 'type', 'url'])) {
            throw new \InvalidArgumentException('Lack of required fields');
        }
        $item = $this->args['item'];
        if ('offlineClass' == $this->args['type']) {
            $resource = $this->getOfflineClassService()->getClass($item['offlineClassId']);
        } elseif ('projectPlan' == $this->args['type']) {
            $resource = $this->getProjectPlanService()->getProjectPlan($item['projectPlanId']);
        }
        if (empty($resource) || 'published' != $resource['status'] || !in_array($this->args['type'], ['offlineClass', 'projectPlan'])) {
            return true;
        }
        $this->sendSmsNotification($item);

        $dingTalkSetting = $this->getSettingService()->get('dingtalk_notification', []);
        $mailSetting = $this->getSettingService()->get('mail_notification', []);
        if (!empty($mailSetting['project_plan_progress'])) {
            $types[] = 'email';
        }

        if (!empty($dingTalkSetting['evaluation_push'])) {
            $types[] = 'dingtalk';
        }

        if (empty($types)) {
            return;
        }
        list($to, $content) = $this->buildNotificationData($item, $resource);

        $this->biz->offsetGet('notification_default')->send($types, $to, $content);

        return true;
    }

    protected function sendSmsNotification($item)
    {
        if (!$this->getSmsService()->isOpen('sms_survey_push')) {
            return;
        }

        if ('offlineClass' == $this->args['type']) {
            $type = 'offline_class';
            $targetId = $item['offlineClassId'];
        } elseif ('projectPlan' == $this->args['type']) {
            $type = 'project_plan';
            $targetId = $item['projectPlanId'];
        }

        $to = [
            'type' => $type,
            'projectPlanId' => $targetId,
            'offlineClassId' => $targetId,
            'startNum' => 0,
            'perPageNum' => 20,
        ];
        $content = [
            'template' => 'survey_push',
            'params' => [
                'sitename' => SettingToolkit::getSetting('site.name', 'EDUSOHO'),
            ],
        ];
        $this->biz->offsetGet('notification_sms')->send($to, $content);

        return true;
    }

    protected function buildNotificationData($item, $resource)
    {
        if ('offlineClass' == $this->args['type']) {
            $type = 'offline_class';
            $targetId = $item['offlineClassId'];
            $resourceTitle = $resource['title'];
        } elseif ('projectPlan' == $this->args['type']) {
            $type = 'project_plan';
            $targetId = $item['projectPlanId'];
            $resourceTitle = $resource['name'];
        } else {
            return true;
        }

        $to = [
            'type' => $type,
            'projectPlanId' => $targetId,
            'offlineClassId' => $targetId,
            'startNum' => 0,
            'perPageNum' => 20,
        ];

        $content = [
            'template' => 'evaluation_push',
            'params' => [
                'batch' => 'evaluation_push'.$type.$item['id'].time(),
                'url' => $this->args['url'],
                'resourceTitle' => $resourceTitle,
                'targetId' => $resource['id'],
                'startTime' => $item['startTime'],
            ],
        ];

        return [$to, $content];
    }

    /**
     * @return SettingService
     */
    protected function getSettingService()
    {
        return $this->biz->service('System:SettingService');
    }

    /**
     * @return ProjectPlanService
     */
    protected function getProjectPlanService()
    {
        return $this->biz->service('CorporateTrainingBundle:ProjectPlan:ProjectPlanService');
    }

    /**
     * @return OfflineClassService
     */
    protected function getOfflineClassService()
    {
        return $this->biz->service('OfflineCourseProPlugin:OfflineClass:OfflineClassService');
    }

    protected function getSmsService()
    {
        return $this->biz->service('Sms:SmsService');
    }
}
