<?php

namespace CorporateTrainingBundle\Biz\NotificationCenter\Job;

use AppBundle\Common\ArrayToolkit;
use Biz\System\Service\SettingService;
use Codeages\Biz\Framework\Scheduler\AbstractJob;
use SurveyPlugin\Biz\Survey\Service\SurveyResultService;
use Codeages\Biz\Framework\Scheduler\Service\SchedulerService;
use OfflineCourseProPlugin\Biz\OfflineClass\Service\MemberService;
use CorporateTrainingBundle\Biz\ProjectPlan\Service\ProjectPlanService;
use OfflineCourseProPlugin\Biz\OfflineClass\Service\OfflineClassService;
use CorporateTrainingBundle\Biz\OfflineCourse\Service\OfflineCourseSurveyService;

class ResourceSurveyUrgeNotificationJob extends AbstractJob
{
    public function execute()
    {
        if (!ArrayToolkit::requireds($this->args, ['item', 'type', 'url'])) {
            throw new \InvalidArgumentException('Lack of required fields');
        }
        $item = $this->args['item'];
        if ('offlineClass' == $this->args['type']) {
            $resource = $this->getOfflineClassService()->getClass($item['offlineClassId']);
        } elseif ('projectPlan' == $this->args['type']) {
            $resource = $this->getProjectPlanService()->getProjectPlan($item['projectPlanId']);
        }
        if (time() > strtotime('+14 day 08:00:00', $resource['endTime'])) {
            $this->getSchedulerService()->deleteJobByName('ResourceQuestionnaireUrgeNotificationJob_'.$this->args['type'].$item['id']);

            return true;
        }
        if (empty($resource) || 'published' != $resource['status'] || !in_array($this->args['type'], ['offlineClass', 'projectPlan'])) {
            return true;
        }

        $dingTalkSetting = $this->getSettingService()->get('dingtalk_notification', []);
        $userIds = $this->getNotificationUserIds($item);
        if (empty($dingTalkSetting['evaluation_urge']) || empty($userIds)) {
            return;
        }

        list($to, $content) = $this->buildNotificationData($item, $resource, $userIds);

        $this->biz->offsetGet('notification_default')->send(['dingtalk'], $to, $content);

        return true;
    }

    protected function getNotificationUserIds($item)
    {
        if ('offlineClass' == $this->args['type']) {
            $surveys = $this->getOfflineCourseSurveyService()->findOfflineCourseSurveysByTargetIdAndTargetType($item['id'], 'offlineClassItem');
            if (empty($surveys)) {
                return [];
            }
            $surveyResults = $this->getSurveyResultService()->searchSurveyResults(['surveyId' => $surveys[0]['id']], [], 0, PHP_INT_MAX, ['userId']);
            $userIds = ArrayToolkit::column($surveyResults, 'userId');
            $members = $this->getOfflineClassMemberService()->searchMembers(['offlineClassId' => $item['offlineClassId'], 'excludeUserIds' => $userIds], [], 0, PHP_INT_MAX, ['userId']);
        } elseif ('projectPlan' == $this->args['type']) {
            $surveys = $this->getOfflineCourseSurveyService()->findOfflineCourseSurveysByTargetIdAndTargetType($item['id'], 'projectPlanItem');
            if (empty($surveys)) {
                return [];
            }
            $surveyResults = $this->getSurveyResultService()->searchSurveyResults(['surveyId' => $surveys[0]['id'], [], 0, PHP_INT_MAX, ['userId']]);
            $userIds = ArrayToolkit::column($surveyResults, 'userId');
            $members = $this->getProjectPlanMemberService()->searchProjectPlanMembers(['projectPlanId' => $item['projectPlanId'], 'excludeUserIds' => $userIds], [], 0, PHP_INT_MAX, ['userId']);
        }

        return ArrayToolkit::column($members, 'userId');
    }

    protected function buildNotificationData($item, $resource, $userIds)
    {
        $to = [
            'type' => 'user',
            'userIds' => $userIds,
            'startNum' => 0,
            'perPageNum' => 20,
        ];
        $content = [
            'template' => 'evaluation_push',
            'params' => [
                'batch' => 'evaluation_push'.$this->args['type'].$item['id'].time(),
                'url' => $this->args['url'],
                'resourceTitle' => empty($resource['name']) ? $resource['title'] : $resource['name'],
                'targetId' => $resource['id'],
                'startTime' => $item['startTime'],
            ],
        ];

        return [$to, $content];
    }

    /**
     * @return SchedulerService
     */
    private function getSchedulerService()
    {
        return $this->biz->service('Scheduler:SchedulerService');
    }

    /**
     * @return SettingService
     */
    protected function getSettingService()
    {
        return $this->biz->service('System:SettingService');
    }

    /**
     * @return ProjectPlanService
     */
    protected function getProjectPlanService()
    {
        return $this->biz->service('CorporateTrainingBundle:ProjectPlan:ProjectPlanService');
    }

    /**
     * @return OfflineClassService
     */
    protected function getOfflineClassService()
    {
        return $this->biz->service('OfflineCourseProPlugin:OfflineClass:OfflineClassService');
    }

    /**
     * @return SurveyResultService
     */
    protected function getSurveyResultService()
    {
        return $this->biz->service('SurveyPlugin:Survey:SurveyResultService');
    }

    /**
     * @return MemberService
     */
    protected function getOfflineClassMemberService()
    {
        return $this->biz->service('OfflineCourseProPlugin:OfflineClass:MemberService');
    }

    /**
     * @return OfflineCourseSurveyService
     */
    protected function getOfflineCourseSurveyService()
    {
        return $this->biz->service('CorporateTrainingBundle:OfflineCourse:OfflineCourseSurveyService');
    }

    /**
     * @return \CorporateTrainingBundle\Biz\ProjectPlan\Service\MemberService
     */
    protected function getProjectPlanMemberService()
    {
        return $this->biz->service('CorporateTrainingBundle:ProjectPlan:MemberService');
    }
}
